package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EntityFilters implements Enum {

    @JsonProperty("Entity")
    ENTITY("Entity", "1"),

    @JsonProperty("Attributes")
    ATTRIBUTES("Attributes", "2"),

    @JsonProperty("Privileges")
    PRIVILEGES("Privileges", "4"),

    @JsonProperty("Relationships")
    RELATIONSHIPS("Relationships", "8"),

    @JsonProperty("All")
    ALL("All", "15");

    private final String name;
    private final String value;

    private EntityFilters(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
