package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CascadeType implements Enum {

    @JsonProperty("NoCascade")
    NO_CASCADE("NoCascade", "0"),

    @JsonProperty("Cascade")
    CASCADE("Cascade", "1"),

    @JsonProperty("Active")
    ACTIVE("Active", "2"),

    @JsonProperty("UserOwned")
    USER_OWNED("UserOwned", "3"),

    @JsonProperty("RemoveLink")
    REMOVE_LINK("RemoveLink", "4"),

    @JsonProperty("Restrict")
    RESTRICT("Restrict", "5");

    private final String name;
    private final String value;

    private CascadeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
