package microsoft.dynamics.crm.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AppconfigCollectionRequest;

public final class Appconfigs extends AppconfigCollectionRequest {

    public Appconfigs(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Appconfiginstances appconfig_appconfiginstance() {
        return new Appconfiginstances(contextPath.addSegment("appconfig_appconfiginstance"));
    }

    public Systemusers appconfig_createdby() {
        return new Systemusers(contextPath.addSegment("appconfig_createdby"));
    }

    public Systemusers appconfig_createdonbehalfby() {
        return new Systemusers(contextPath.addSegment("appconfig_createdonbehalfby"));
    }

    public Systemusers appconfig_modifiedby() {
        return new Systemusers(contextPath.addSegment("appconfig_modifiedby"));
    }

    public Systemusers appconfig_modifiedonbehalfby() {
        return new Systemusers(contextPath.addSegment("appconfig_modifiedonbehalfby"));
    }

    public Navigationsettings appconfig_navigationsetting() {
        return new Navigationsettings(contextPath.addSegment("appconfig_navigationsetting"));
    }

    public Appmodules appmodule_appconfig() {
        return new Appmodules(contextPath.addSegment("appmodule_appconfig"));
    }

    public Organizations organization_appconfig() {
        return new Organizations(contextPath.addSegment("organization_appconfig"));
    }
}
