package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Position;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PositionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;

@JsonIgnoreType
public class PositionRequest extends EntityRequest<Position> {

    public PositionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Position.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public AsyncoperationCollectionRequest position_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("position_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest position_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("position_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest position_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("position_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest position_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("position_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest position_users() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("position_users"), Optional.empty());
    }

    public SystemuserRequest position_users(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("position_users").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public PositionRequest parentpositionid() {
        return new PositionRequest(contextPath.addSegment("parentpositionid"), Optional.empty());
    }

    public PositionCollectionRequest position_parent_position() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("position_parent_position"), Optional.empty());
    }

    public PositionRequest position_parent_position(String positionid) {
        return new PositionRequest(contextPath.addSegment("position_parent_position").addKeys(new NameValue(positionid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest position_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("position_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest position_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("position_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public ConnectionCollectionRequest position_connection1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("position_connection1"), Optional.empty());
    }

    public ConnectionRequest position_connection1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("position_connection1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest position_connection2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("position_connection2"), Optional.empty());
    }

    public ConnectionRequest position_connection2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("position_connection2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest position_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Position_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest position_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Position_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
