package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Appconfig;
import microsoft.dynamics.crm.entity.request.AppconfigRequest;
import microsoft.dynamics.crm.entity.request.AppconfiginstanceRequest;
import microsoft.dynamics.crm.entity.request.NavigationsettingRequest;

public class AppconfigCollectionRequest extends CollectionPageEntityRequest<Appconfig, AppconfigRequest>{

    protected ContextPath contextPath;

    public AppconfigCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Appconfig.class, cp -> new AppconfigRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public NavigationsettingCollectionRequest appconfig_navigationsetting() {
        return new NavigationsettingCollectionRequest(contextPath.addSegment("appconfig_navigationsetting"), Optional.empty());
    }

    public NavigationsettingRequest appconfig_navigationsetting(String navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("appconfig_navigationsetting").addKeys(new NameValue(navigationsettingid.toString())), Optional.empty());
    }

    public AppconfiginstanceCollectionRequest appconfig_appconfiginstance() {
        return new AppconfiginstanceCollectionRequest(contextPath.addSegment("appconfig_appconfiginstance"), Optional.empty());
    }

    public AppconfiginstanceRequest appconfig_appconfiginstance(String appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("appconfig_appconfiginstance").addKeys(new NameValue(appconfiginstanceid.toString())), Optional.empty());
    }

    @Function(name = "RetrieveUnpublishedMultiple")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Appconfig> retrieveUnpublishedMultiple() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublishedMultiple"), Appconfig.class, _parameters);
    }

}
