package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ExpiredprocessRequest;
import microsoft.dynamics.crm.entity.request.NewprocessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TranslationprocessRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "stepname", 
    "_childworkflowinstanceid_value", 
    "_ownerid_value", 
    "_modifiedby_value", 
    "repetitioncount", 
    "activityname", 
    "_owningbusinessunit_value", 
    "interactionactivityresult", 
    "_owninguser_value", 
    "_createdby_value", 
    "outputs", 
    "inputs", 
    "inputs_name", 
    "outputs_name", 
    "iterationcount", 
    "completedon", 
    "workflowlogid", 
    "message", 
    "duration", 
    "createdon", 
    "_createdonbehalfby_value", 
    "status", 
    "_modifiedonbehalfby_value", 
    "_owningteam_value", 
    "description", 
    "errortext", 
    "_regardingobjectid_value", 
    "modifiedon", 
    "stagename", 
    "startedon", 
    "_asyncoperationid_value", 
    "errorcode", 
    "repetitionid"})
@JsonInclude(Include.NON_NULL)
public class Workflowlog extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.workflowlog";
    }

    @JsonProperty("stepname")
    protected String stepname;

    @JsonProperty("_childworkflowinstanceid_value")
    protected String _childworkflowinstanceid_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("repetitioncount")
    protected Integer repetitioncount;

    @JsonProperty("activityname")
    protected String activityname;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("interactionactivityresult")
    protected String interactionactivityresult;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("outputs")
    protected byte[] outputs;

    @JsonProperty("inputs")
    protected byte[] inputs;

    @JsonProperty("inputs_name")
    protected String inputs_name;

    @JsonProperty("outputs_name")
    protected String outputs_name;

    @JsonProperty("iterationcount")
    protected Integer iterationcount;

    @JsonProperty("completedon")
    protected OffsetDateTime completedon;

    @JsonProperty("workflowlogid")
    protected String workflowlogid;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("duration")
    protected Integer duration;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("status")
    protected Integer status;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("errortext")
    protected String errortext;

    @JsonProperty("_regardingobjectid_value")
    protected String _regardingobjectid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("stagename")
    protected String stagename;

    @JsonProperty("startedon")
    protected OffsetDateTime startedon;

    @JsonProperty("_asyncoperationid_value")
    protected String _asyncoperationid_value;

    @JsonProperty("errorcode")
    protected Integer errorcode;

    @JsonProperty("repetitionid")
    protected String repetitionid;

    protected Workflowlog() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkflowlog() {
        return new Builder();
    }

    public static final class Builder {
        private String stepname;
        private String _childworkflowinstanceid_value;
        private String _ownerid_value;
        private String _modifiedby_value;
        private Integer repetitioncount;
        private String activityname;
        private String _owningbusinessunit_value;
        private String interactionactivityresult;
        private String _owninguser_value;
        private String _createdby_value;
        private byte[] outputs;
        private byte[] inputs;
        private String inputs_name;
        private String outputs_name;
        private Integer iterationcount;
        private OffsetDateTime completedon;
        private String workflowlogid;
        private String message;
        private Integer duration;
        private OffsetDateTime createdon;
        private String _createdonbehalfby_value;
        private Integer status;
        private String _modifiedonbehalfby_value;
        private String _owningteam_value;
        private String description;
        private String errortext;
        private String _regardingobjectid_value;
        private OffsetDateTime modifiedon;
        private String stagename;
        private OffsetDateTime startedon;
        private String _asyncoperationid_value;
        private Integer errorcode;
        private String repetitionid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder stepname(String stepname) {
            this.stepname = stepname;
            this.changedFields = changedFields.add("stepname");
            return this;
        }

        public Builder _childworkflowinstanceid_value(String _childworkflowinstanceid_value) {
            this._childworkflowinstanceid_value = _childworkflowinstanceid_value;
            this.changedFields = changedFields.add("_childworkflowinstanceid_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder repetitioncount(Integer repetitioncount) {
            this.repetitioncount = repetitioncount;
            this.changedFields = changedFields.add("repetitioncount");
            return this;
        }

        public Builder activityname(String activityname) {
            this.activityname = activityname;
            this.changedFields = changedFields.add("activityname");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder interactionactivityresult(String interactionactivityresult) {
            this.interactionactivityresult = interactionactivityresult;
            this.changedFields = changedFields.add("interactionactivityresult");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder outputs(byte[] outputs) {
            this.outputs = outputs;
            this.changedFields = changedFields.add("outputs");
            return this;
        }

        public Builder inputs(byte[] inputs) {
            this.inputs = inputs;
            this.changedFields = changedFields.add("inputs");
            return this;
        }

        public Builder inputs_name(String inputs_name) {
            this.inputs_name = inputs_name;
            this.changedFields = changedFields.add("inputs_name");
            return this;
        }

        public Builder outputs_name(String outputs_name) {
            this.outputs_name = outputs_name;
            this.changedFields = changedFields.add("outputs_name");
            return this;
        }

        public Builder iterationcount(Integer iterationcount) {
            this.iterationcount = iterationcount;
            this.changedFields = changedFields.add("iterationcount");
            return this;
        }

        public Builder completedon(OffsetDateTime completedon) {
            this.completedon = completedon;
            this.changedFields = changedFields.add("completedon");
            return this;
        }

        public Builder workflowlogid(String workflowlogid) {
            this.workflowlogid = workflowlogid;
            this.changedFields = changedFields.add("workflowlogid");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder status(Integer status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder errortext(String errortext) {
            this.errortext = errortext;
            this.changedFields = changedFields.add("errortext");
            return this;
        }

        public Builder _regardingobjectid_value(String _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder stagename(String stagename) {
            this.stagename = stagename;
            this.changedFields = changedFields.add("stagename");
            return this;
        }

        public Builder startedon(OffsetDateTime startedon) {
            this.startedon = startedon;
            this.changedFields = changedFields.add("startedon");
            return this;
        }

        public Builder _asyncoperationid_value(String _asyncoperationid_value) {
            this._asyncoperationid_value = _asyncoperationid_value;
            this.changedFields = changedFields.add("_asyncoperationid_value");
            return this;
        }

        public Builder errorcode(Integer errorcode) {
            this.errorcode = errorcode;
            this.changedFields = changedFields.add("errorcode");
            return this;
        }

        public Builder repetitionid(String repetitionid) {
            this.repetitionid = repetitionid;
            this.changedFields = changedFields.add("repetitionid");
            return this;
        }

        public Workflowlog build() {
            Workflowlog _x = new Workflowlog();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.workflowlog";
            _x.stepname = stepname;
            _x._childworkflowinstanceid_value = _childworkflowinstanceid_value;
            _x._ownerid_value = _ownerid_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.repetitioncount = repetitioncount;
            _x.activityname = activityname;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.interactionactivityresult = interactionactivityresult;
            _x._owninguser_value = _owninguser_value;
            _x._createdby_value = _createdby_value;
            _x.outputs = outputs;
            _x.inputs = inputs;
            _x.inputs_name = inputs_name;
            _x.outputs_name = outputs_name;
            _x.iterationcount = iterationcount;
            _x.completedon = completedon;
            _x.workflowlogid = workflowlogid;
            _x.message = message;
            _x.duration = duration;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.status = status;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._owningteam_value = _owningteam_value;
            _x.description = description;
            _x.errortext = errortext;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.modifiedon = modifiedon;
            _x.stagename = stagename;
            _x.startedon = startedon;
            _x._asyncoperationid_value = _asyncoperationid_value;
            _x.errorcode = errorcode;
            _x.repetitionid = repetitionid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && workflowlogid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(workflowlogid.toString()));
        }
    }

    @Property(name="stepname")
    @JsonIgnore
    public Optional<String> getStepname() {
        return Optional.ofNullable(stepname);
    }

    public Workflowlog withStepname(String stepname) {
        Checks.checkIsAscii(stepname);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("stepname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.stepname = stepname;
        return _x;
    }

    @Property(name="_childworkflowinstanceid_value")
    @JsonIgnore
    public Optional<String> get_childworkflowinstanceid_value() {
        return Optional.ofNullable(_childworkflowinstanceid_value);
    }

    public Workflowlog with_childworkflowinstanceid_value(String _childworkflowinstanceid_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_childworkflowinstanceid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._childworkflowinstanceid_value = _childworkflowinstanceid_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Workflowlog with_ownerid_value(String _ownerid_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Workflowlog with_modifiedby_value(String _modifiedby_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="repetitioncount")
    @JsonIgnore
    public Optional<Integer> getRepetitioncount() {
        return Optional.ofNullable(repetitioncount);
    }

    public Workflowlog withRepetitioncount(Integer repetitioncount) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("repetitioncount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.repetitioncount = repetitioncount;
        return _x;
    }

    @Property(name="activityname")
    @JsonIgnore
    public Optional<String> getActivityname() {
        return Optional.ofNullable(activityname);
    }

    public Workflowlog withActivityname(String activityname) {
        Checks.checkIsAscii(activityname);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("activityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.activityname = activityname;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Workflowlog with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="interactionactivityresult")
    @JsonIgnore
    public Optional<String> getInteractionactivityresult() {
        return Optional.ofNullable(interactionactivityresult);
    }

    public Workflowlog withInteractionactivityresult(String interactionactivityresult) {
        Checks.checkIsAscii(interactionactivityresult);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("interactionactivityresult");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.interactionactivityresult = interactionactivityresult;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Workflowlog with_owninguser_value(String _owninguser_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Workflowlog with_createdby_value(String _createdby_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="outputs")
    @JsonIgnore
    public Optional<byte[]> getOutputs() {
        return Optional.ofNullable(outputs);
    }

    public Workflowlog withOutputs(byte[] outputs) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("outputs");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.outputs = outputs;
        return _x;
    }

    @Property(name="inputs")
    @JsonIgnore
    public Optional<byte[]> getInputs() {
        return Optional.ofNullable(inputs);
    }

    public Workflowlog withInputs(byte[] inputs) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("inputs");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.inputs = inputs;
        return _x;
    }

    @Property(name="inputs_name")
    @JsonIgnore
    public Optional<String> getInputs_name() {
        return Optional.ofNullable(inputs_name);
    }

    public Workflowlog withInputs_name(String inputs_name) {
        Checks.checkIsAscii(inputs_name);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("inputs_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.inputs_name = inputs_name;
        return _x;
    }

    @Property(name="outputs_name")
    @JsonIgnore
    public Optional<String> getOutputs_name() {
        return Optional.ofNullable(outputs_name);
    }

    public Workflowlog withOutputs_name(String outputs_name) {
        Checks.checkIsAscii(outputs_name);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("outputs_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.outputs_name = outputs_name;
        return _x;
    }

    @Property(name="iterationcount")
    @JsonIgnore
    public Optional<Integer> getIterationcount() {
        return Optional.ofNullable(iterationcount);
    }

    public Workflowlog withIterationcount(Integer iterationcount) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("iterationcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.iterationcount = iterationcount;
        return _x;
    }

    @Property(name="completedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedon() {
        return Optional.ofNullable(completedon);
    }

    public Workflowlog withCompletedon(OffsetDateTime completedon) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("completedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.completedon = completedon;
        return _x;
    }

    @Property(name="workflowlogid")
    @JsonIgnore
    public Optional<String> getWorkflowlogid() {
        return Optional.ofNullable(workflowlogid);
    }

    public Workflowlog withWorkflowlogid(String workflowlogid) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("workflowlogid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.workflowlogid = workflowlogid;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public Workflowlog withMessage(String message) {
        Checks.checkIsAscii(message);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("message");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.message = message;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Integer> getDuration() {
        return Optional.ofNullable(duration);
    }

    public Workflowlog withDuration(Integer duration) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.duration = duration;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Workflowlog withCreatedon(OffsetDateTime createdon) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Workflowlog with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<Integer> getStatus() {
        return Optional.ofNullable(status);
    }

    public Workflowlog withStatus(Integer status) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.status = status;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Workflowlog with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Workflowlog with_owningteam_value(String _owningteam_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Workflowlog withDescription(String description) {
        Checks.checkIsAscii(description);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.description = description;
        return _x;
    }

    @Property(name="errortext")
    @JsonIgnore
    public Optional<String> getErrortext() {
        return Optional.ofNullable(errortext);
    }

    public Workflowlog withErrortext(String errortext) {
        Checks.checkIsAscii(errortext);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("errortext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.errortext = errortext;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<String> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Workflowlog with_regardingobjectid_value(String _regardingobjectid_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Workflowlog withModifiedon(OffsetDateTime modifiedon) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="stagename")
    @JsonIgnore
    public Optional<String> getStagename() {
        return Optional.ofNullable(stagename);
    }

    public Workflowlog withStagename(String stagename) {
        Checks.checkIsAscii(stagename);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("stagename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.stagename = stagename;
        return _x;
    }

    @Property(name="startedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartedon() {
        return Optional.ofNullable(startedon);
    }

    public Workflowlog withStartedon(OffsetDateTime startedon) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("startedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.startedon = startedon;
        return _x;
    }

    @Property(name="_asyncoperationid_value")
    @JsonIgnore
    public Optional<String> get_asyncoperationid_value() {
        return Optional.ofNullable(_asyncoperationid_value);
    }

    public Workflowlog with_asyncoperationid_value(String _asyncoperationid_value) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("_asyncoperationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x._asyncoperationid_value = _asyncoperationid_value;
        return _x;
    }

    @Property(name="errorcode")
    @JsonIgnore
    public Optional<Integer> getErrorcode() {
        return Optional.ofNullable(errorcode);
    }

    public Workflowlog withErrorcode(Integer errorcode) {
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("errorcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.errorcode = errorcode;
        return _x;
    }

    @Property(name="repetitionid")
    @JsonIgnore
    public Optional<String> getRepetitionid() {
        return Optional.ofNullable(repetitionid);
    }

    public Workflowlog withRepetitionid(String repetitionid) {
        Checks.checkIsAscii(repetitionid);
        Workflowlog _x = _copy();
        _x.changedFields = changedFields.add("repetitionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.workflowlog");
        _x.repetitionid = repetitionid;
        return _x;
    }

    public Workflowlog withUnmappedField(String name, String value) {
        Workflowlog _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="asyncoperationid_processsession")
    @JsonIgnore
    public ProcesssessionRequest getAsyncoperationid_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("asyncoperationid_processsession"), RequestHelper.getValue(unmappedFields, "asyncoperationid_processsession"));
    }

    @NavigationProperty(name="childworkflowinstanceid_processsession")
    @JsonIgnore
    public ProcesssessionRequest getChildworkflowinstanceid_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("childworkflowinstanceid_processsession"), RequestHelper.getValue(unmappedFields, "childworkflowinstanceid_processsession"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="childworkflowinstanceid_asyncoperation")
    @JsonIgnore
    public AsyncoperationRequest getChildworkflowinstanceid_asyncoperation() {
        return new AsyncoperationRequest(contextPath.addSegment("childworkflowinstanceid_asyncoperation"), RequestHelper.getValue(unmappedFields, "childworkflowinstanceid_asyncoperation"));
    }

    @NavigationProperty(name="ExpiredProcess_asyncoperationid")
    @JsonIgnore
    public ExpiredprocessRequest getExpiredProcess_asyncoperationid() {
        return new ExpiredprocessRequest(contextPath.addSegment("ExpiredProcess_asyncoperationid"), RequestHelper.getValue(unmappedFields, "ExpiredProcess_asyncoperationid"));
    }

    @NavigationProperty(name="TranslationProcess_asyncoperationid")
    @JsonIgnore
    public TranslationprocessRequest getTranslationProcess_asyncoperationid() {
        return new TranslationprocessRequest(contextPath.addSegment("TranslationProcess_asyncoperationid"), RequestHelper.getValue(unmappedFields, "TranslationProcess_asyncoperationid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="asyncoperationid_asyncoperation")
    @JsonIgnore
    public AsyncoperationRequest getAsyncoperationid_asyncoperation() {
        return new AsyncoperationRequest(contextPath.addSegment("asyncoperationid_asyncoperation"), RequestHelper.getValue(unmappedFields, "asyncoperationid_asyncoperation"));
    }

    @NavigationProperty(name="NewProcess_asyncoperationid")
    @JsonIgnore
    public NewprocessRequest getNewProcess_asyncoperationid() {
        return new NewprocessRequest(contextPath.addSegment("NewProcess_asyncoperationid"), RequestHelper.getValue(unmappedFields, "NewProcess_asyncoperationid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="workflowlog_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getWorkflowlog_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("workflowlog_FileAttachments"), RequestHelper.getValue(unmappedFields, "workflowlog_FileAttachments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Workflowlog patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Workflowlog _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Workflowlog put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Workflowlog _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Workflowlog _copy() {
        Workflowlog _x = new Workflowlog();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.stepname = stepname;
        _x._childworkflowinstanceid_value = _childworkflowinstanceid_value;
        _x._ownerid_value = _ownerid_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.repetitioncount = repetitioncount;
        _x.activityname = activityname;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.interactionactivityresult = interactionactivityresult;
        _x._owninguser_value = _owninguser_value;
        _x._createdby_value = _createdby_value;
        _x.outputs = outputs;
        _x.inputs = inputs;
        _x.inputs_name = inputs_name;
        _x.outputs_name = outputs_name;
        _x.iterationcount = iterationcount;
        _x.completedon = completedon;
        _x.workflowlogid = workflowlogid;
        _x.message = message;
        _x.duration = duration;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.status = status;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._owningteam_value = _owningteam_value;
        _x.description = description;
        _x.errortext = errortext;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.modifiedon = modifiedon;
        _x.stagename = stagename;
        _x.startedon = startedon;
        _x._asyncoperationid_value = _asyncoperationid_value;
        _x.errorcode = errorcode;
        _x.repetitionid = repetitionid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Workflowlog[");
        b.append("stepname=");
        b.append(this.stepname);
        b.append(", ");
        b.append("_childworkflowinstanceid_value=");
        b.append(this._childworkflowinstanceid_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("repetitioncount=");
        b.append(this.repetitioncount);
        b.append(", ");
        b.append("activityname=");
        b.append(this.activityname);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("interactionactivityresult=");
        b.append(this.interactionactivityresult);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("outputs=");
        b.append(this.outputs);
        b.append(", ");
        b.append("inputs=");
        b.append(this.inputs);
        b.append(", ");
        b.append("inputs_name=");
        b.append(this.inputs_name);
        b.append(", ");
        b.append("outputs_name=");
        b.append(this.outputs_name);
        b.append(", ");
        b.append("iterationcount=");
        b.append(this.iterationcount);
        b.append(", ");
        b.append("completedon=");
        b.append(this.completedon);
        b.append(", ");
        b.append("workflowlogid=");
        b.append(this.workflowlogid);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("errortext=");
        b.append(this.errortext);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("stagename=");
        b.append(this.stagename);
        b.append(", ");
        b.append("startedon=");
        b.append(this.startedon);
        b.append(", ");
        b.append("_asyncoperationid_value=");
        b.append(this._asyncoperationid_value);
        b.append(", ");
        b.append("errorcode=");
        b.append(this.errorcode);
        b.append(", ");
        b.append("repetitionid=");
        b.append(this.repetitionid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
