package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_ownerid_value", 
    "slakpiinstanceid", 
    "versionnumber", 
    "_transactioncurrencyid_value", 
    "description", 
    "lastresumetime", 
    "warningtime", 
    "_owninguser_value", 
    "_owningteam_value", 
    "pausedon", 
    "elapsedtime", 
    "_msdyn_slaitemid_value", 
    "msdyn_actionexecutionstatus", 
    "succeededon", 
    "_modifiedonbehalfby_value", 
    "computedfailuretime", 
    "warningtimereached", 
    "_modifiedby_value", 
    "msdyn_calendarid", 
    "createdon", 
    "_owningbusinessunit_value", 
    "msdyn_prevslakpiinstanceid", 
    "failuretime", 
    "terminalstatereached", 
    "_regarding_value", 
    "status", 
    "successcheckedat", 
    "applicablefromvalue", 
    "modifiedon", 
    "name", 
    "terminalstatetime", 
    "computedwarningtime", 
    "_createdonbehalfby_value", 
    "_createdby_value", 
    "exchangerate", 
    "regardingentityid"})
@JsonInclude(Include.NON_NULL)
public class Slakpiinstance extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.slakpiinstance";
    }

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("slakpiinstanceid")
    protected String slakpiinstanceid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("lastresumetime")
    protected OffsetDateTime lastresumetime;

    @JsonProperty("warningtime")
    protected OffsetDateTime warningtime;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("pausedon")
    protected OffsetDateTime pausedon;

    @JsonProperty("elapsedtime")
    protected Integer elapsedtime;

    @JsonProperty("_msdyn_slaitemid_value")
    protected String _msdyn_slaitemid_value;

    @JsonProperty("msdyn_actionexecutionstatus")
    protected Integer msdyn_actionexecutionstatus;

    @JsonProperty("succeededon")
    protected OffsetDateTime succeededon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("computedfailuretime")
    protected OffsetDateTime computedfailuretime;

    @JsonProperty("warningtimereached")
    protected Integer warningtimereached;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("msdyn_calendarid")
    protected String msdyn_calendarid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("msdyn_prevslakpiinstanceid")
    protected String msdyn_prevslakpiinstanceid;

    @JsonProperty("failuretime")
    protected OffsetDateTime failuretime;

    @JsonProperty("terminalstatereached")
    protected Boolean terminalstatereached;

    @JsonProperty("_regarding_value")
    protected String _regarding_value;

    @JsonProperty("status")
    protected Integer status;

    @JsonProperty("successcheckedat")
    protected OffsetDateTime successcheckedat;

    @JsonProperty("applicablefromvalue")
    protected OffsetDateTime applicablefromvalue;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("terminalstatetime")
    protected OffsetDateTime terminalstatetime;

    @JsonProperty("computedwarningtime")
    protected OffsetDateTime computedwarningtime;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("regardingentityid")
    protected String regardingentityid;

    protected Slakpiinstance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSlakpiinstance() {
        return new Builder();
    }

    public static final class Builder {
        private String _ownerid_value;
        private String slakpiinstanceid;
        private Long versionnumber;
        private String _transactioncurrencyid_value;
        private String description;
        private OffsetDateTime lastresumetime;
        private OffsetDateTime warningtime;
        private String _owninguser_value;
        private String _owningteam_value;
        private OffsetDateTime pausedon;
        private Integer elapsedtime;
        private String _msdyn_slaitemid_value;
        private Integer msdyn_actionexecutionstatus;
        private OffsetDateTime succeededon;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime computedfailuretime;
        private Integer warningtimereached;
        private String _modifiedby_value;
        private String msdyn_calendarid;
        private OffsetDateTime createdon;
        private String _owningbusinessunit_value;
        private String msdyn_prevslakpiinstanceid;
        private OffsetDateTime failuretime;
        private Boolean terminalstatereached;
        private String _regarding_value;
        private Integer status;
        private OffsetDateTime successcheckedat;
        private OffsetDateTime applicablefromvalue;
        private OffsetDateTime modifiedon;
        private String name;
        private OffsetDateTime terminalstatetime;
        private OffsetDateTime computedwarningtime;
        private String _createdonbehalfby_value;
        private String _createdby_value;
        private BigDecimal exchangerate;
        private String regardingentityid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder slakpiinstanceid(String slakpiinstanceid) {
            this.slakpiinstanceid = slakpiinstanceid;
            this.changedFields = changedFields.add("slakpiinstanceid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder lastresumetime(OffsetDateTime lastresumetime) {
            this.lastresumetime = lastresumetime;
            this.changedFields = changedFields.add("lastresumetime");
            return this;
        }

        public Builder warningtime(OffsetDateTime warningtime) {
            this.warningtime = warningtime;
            this.changedFields = changedFields.add("warningtime");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder pausedon(OffsetDateTime pausedon) {
            this.pausedon = pausedon;
            this.changedFields = changedFields.add("pausedon");
            return this;
        }

        public Builder elapsedtime(Integer elapsedtime) {
            this.elapsedtime = elapsedtime;
            this.changedFields = changedFields.add("elapsedtime");
            return this;
        }

        public Builder _msdyn_slaitemid_value(String _msdyn_slaitemid_value) {
            this._msdyn_slaitemid_value = _msdyn_slaitemid_value;
            this.changedFields = changedFields.add("_msdyn_slaitemid_value");
            return this;
        }

        public Builder msdyn_actionexecutionstatus(Integer msdyn_actionexecutionstatus) {
            this.msdyn_actionexecutionstatus = msdyn_actionexecutionstatus;
            this.changedFields = changedFields.add("msdyn_actionexecutionstatus");
            return this;
        }

        public Builder succeededon(OffsetDateTime succeededon) {
            this.succeededon = succeededon;
            this.changedFields = changedFields.add("succeededon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder computedfailuretime(OffsetDateTime computedfailuretime) {
            this.computedfailuretime = computedfailuretime;
            this.changedFields = changedFields.add("computedfailuretime");
            return this;
        }

        public Builder warningtimereached(Integer warningtimereached) {
            this.warningtimereached = warningtimereached;
            this.changedFields = changedFields.add("warningtimereached");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder msdyn_calendarid(String msdyn_calendarid) {
            this.msdyn_calendarid = msdyn_calendarid;
            this.changedFields = changedFields.add("msdyn_calendarid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder msdyn_prevslakpiinstanceid(String msdyn_prevslakpiinstanceid) {
            this.msdyn_prevslakpiinstanceid = msdyn_prevslakpiinstanceid;
            this.changedFields = changedFields.add("msdyn_prevslakpiinstanceid");
            return this;
        }

        public Builder failuretime(OffsetDateTime failuretime) {
            this.failuretime = failuretime;
            this.changedFields = changedFields.add("failuretime");
            return this;
        }

        public Builder terminalstatereached(Boolean terminalstatereached) {
            this.terminalstatereached = terminalstatereached;
            this.changedFields = changedFields.add("terminalstatereached");
            return this;
        }

        public Builder _regarding_value(String _regarding_value) {
            this._regarding_value = _regarding_value;
            this.changedFields = changedFields.add("_regarding_value");
            return this;
        }

        public Builder status(Integer status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder successcheckedat(OffsetDateTime successcheckedat) {
            this.successcheckedat = successcheckedat;
            this.changedFields = changedFields.add("successcheckedat");
            return this;
        }

        public Builder applicablefromvalue(OffsetDateTime applicablefromvalue) {
            this.applicablefromvalue = applicablefromvalue;
            this.changedFields = changedFields.add("applicablefromvalue");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder terminalstatetime(OffsetDateTime terminalstatetime) {
            this.terminalstatetime = terminalstatetime;
            this.changedFields = changedFields.add("terminalstatetime");
            return this;
        }

        public Builder computedwarningtime(OffsetDateTime computedwarningtime) {
            this.computedwarningtime = computedwarningtime;
            this.changedFields = changedFields.add("computedwarningtime");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder regardingentityid(String regardingentityid) {
            this.regardingentityid = regardingentityid;
            this.changedFields = changedFields.add("regardingentityid");
            return this;
        }

        public Slakpiinstance build() {
            Slakpiinstance _x = new Slakpiinstance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.slakpiinstance";
            _x._ownerid_value = _ownerid_value;
            _x.slakpiinstanceid = slakpiinstanceid;
            _x.versionnumber = versionnumber;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.description = description;
            _x.lastresumetime = lastresumetime;
            _x.warningtime = warningtime;
            _x._owninguser_value = _owninguser_value;
            _x._owningteam_value = _owningteam_value;
            _x.pausedon = pausedon;
            _x.elapsedtime = elapsedtime;
            _x._msdyn_slaitemid_value = _msdyn_slaitemid_value;
            _x.msdyn_actionexecutionstatus = msdyn_actionexecutionstatus;
            _x.succeededon = succeededon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.computedfailuretime = computedfailuretime;
            _x.warningtimereached = warningtimereached;
            _x._modifiedby_value = _modifiedby_value;
            _x.msdyn_calendarid = msdyn_calendarid;
            _x.createdon = createdon;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.msdyn_prevslakpiinstanceid = msdyn_prevslakpiinstanceid;
            _x.failuretime = failuretime;
            _x.terminalstatereached = terminalstatereached;
            _x._regarding_value = _regarding_value;
            _x.status = status;
            _x.successcheckedat = successcheckedat;
            _x.applicablefromvalue = applicablefromvalue;
            _x.modifiedon = modifiedon;
            _x.name = name;
            _x.terminalstatetime = terminalstatetime;
            _x.computedwarningtime = computedwarningtime;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.exchangerate = exchangerate;
            _x.regardingentityid = regardingentityid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && slakpiinstanceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(slakpiinstanceid.toString()));
        }
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Slakpiinstance with_ownerid_value(String _ownerid_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="slakpiinstanceid")
    @JsonIgnore
    public Optional<String> getSlakpiinstanceid() {
        return Optional.ofNullable(slakpiinstanceid);
    }

    public Slakpiinstance withSlakpiinstanceid(String slakpiinstanceid) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("slakpiinstanceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.slakpiinstanceid = slakpiinstanceid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Slakpiinstance withVersionnumber(Long versionnumber) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Slakpiinstance with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Slakpiinstance withDescription(String description) {
        Checks.checkIsAscii(description);
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.description = description;
        return _x;
    }

    @Property(name="lastresumetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastresumetime() {
        return Optional.ofNullable(lastresumetime);
    }

    public Slakpiinstance withLastresumetime(OffsetDateTime lastresumetime) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("lastresumetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.lastresumetime = lastresumetime;
        return _x;
    }

    @Property(name="warningtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getWarningtime() {
        return Optional.ofNullable(warningtime);
    }

    public Slakpiinstance withWarningtime(OffsetDateTime warningtime) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("warningtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.warningtime = warningtime;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Slakpiinstance with_owninguser_value(String _owninguser_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Slakpiinstance with_owningteam_value(String _owningteam_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="pausedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getPausedon() {
        return Optional.ofNullable(pausedon);
    }

    public Slakpiinstance withPausedon(OffsetDateTime pausedon) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("pausedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.pausedon = pausedon;
        return _x;
    }

    @Property(name="elapsedtime")
    @JsonIgnore
    public Optional<Integer> getElapsedtime() {
        return Optional.ofNullable(elapsedtime);
    }

    public Slakpiinstance withElapsedtime(Integer elapsedtime) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("elapsedtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.elapsedtime = elapsedtime;
        return _x;
    }

    @Property(name="_msdyn_slaitemid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_slaitemid_value() {
        return Optional.ofNullable(_msdyn_slaitemid_value);
    }

    public Slakpiinstance with_msdyn_slaitemid_value(String _msdyn_slaitemid_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_slaitemid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._msdyn_slaitemid_value = _msdyn_slaitemid_value;
        return _x;
    }

    @Property(name="msdyn_actionexecutionstatus")
    @JsonIgnore
    public Optional<Integer> getMsdyn_actionexecutionstatus() {
        return Optional.ofNullable(msdyn_actionexecutionstatus);
    }

    public Slakpiinstance withMsdyn_actionexecutionstatus(Integer msdyn_actionexecutionstatus) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("msdyn_actionexecutionstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.msdyn_actionexecutionstatus = msdyn_actionexecutionstatus;
        return _x;
    }

    @Property(name="succeededon")
    @JsonIgnore
    public Optional<OffsetDateTime> getSucceededon() {
        return Optional.ofNullable(succeededon);
    }

    public Slakpiinstance withSucceededon(OffsetDateTime succeededon) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("succeededon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.succeededon = succeededon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Slakpiinstance with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="computedfailuretime")
    @JsonIgnore
    public Optional<OffsetDateTime> getComputedfailuretime() {
        return Optional.ofNullable(computedfailuretime);
    }

    public Slakpiinstance withComputedfailuretime(OffsetDateTime computedfailuretime) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("computedfailuretime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.computedfailuretime = computedfailuretime;
        return _x;
    }

    @Property(name="warningtimereached")
    @JsonIgnore
    public Optional<Integer> getWarningtimereached() {
        return Optional.ofNullable(warningtimereached);
    }

    public Slakpiinstance withWarningtimereached(Integer warningtimereached) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("warningtimereached");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.warningtimereached = warningtimereached;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Slakpiinstance with_modifiedby_value(String _modifiedby_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="msdyn_calendarid")
    @JsonIgnore
    public Optional<String> getMsdyn_calendarid() {
        return Optional.ofNullable(msdyn_calendarid);
    }

    public Slakpiinstance withMsdyn_calendarid(String msdyn_calendarid) {
        Checks.checkIsAscii(msdyn_calendarid);
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("msdyn_calendarid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.msdyn_calendarid = msdyn_calendarid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Slakpiinstance withCreatedon(OffsetDateTime createdon) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Slakpiinstance with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="msdyn_prevslakpiinstanceid")
    @JsonIgnore
    public Optional<String> getMsdyn_prevslakpiinstanceid() {
        return Optional.ofNullable(msdyn_prevslakpiinstanceid);
    }

    public Slakpiinstance withMsdyn_prevslakpiinstanceid(String msdyn_prevslakpiinstanceid) {
        Checks.checkIsAscii(msdyn_prevslakpiinstanceid);
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("msdyn_prevslakpiinstanceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.msdyn_prevslakpiinstanceid = msdyn_prevslakpiinstanceid;
        return _x;
    }

    @Property(name="failuretime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFailuretime() {
        return Optional.ofNullable(failuretime);
    }

    public Slakpiinstance withFailuretime(OffsetDateTime failuretime) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("failuretime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.failuretime = failuretime;
        return _x;
    }

    @Property(name="terminalstatereached")
    @JsonIgnore
    public Optional<Boolean> getTerminalstatereached() {
        return Optional.ofNullable(terminalstatereached);
    }

    public Slakpiinstance withTerminalstatereached(Boolean terminalstatereached) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("terminalstatereached");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.terminalstatereached = terminalstatereached;
        return _x;
    }

    @Property(name="_regarding_value")
    @JsonIgnore
    public Optional<String> get_regarding_value() {
        return Optional.ofNullable(_regarding_value);
    }

    public Slakpiinstance with_regarding_value(String _regarding_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_regarding_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._regarding_value = _regarding_value;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<Integer> getStatus() {
        return Optional.ofNullable(status);
    }

    public Slakpiinstance withStatus(Integer status) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.status = status;
        return _x;
    }

    @Property(name="successcheckedat")
    @JsonIgnore
    public Optional<OffsetDateTime> getSuccesscheckedat() {
        return Optional.ofNullable(successcheckedat);
    }

    public Slakpiinstance withSuccesscheckedat(OffsetDateTime successcheckedat) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("successcheckedat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.successcheckedat = successcheckedat;
        return _x;
    }

    @Property(name="applicablefromvalue")
    @JsonIgnore
    public Optional<OffsetDateTime> getApplicablefromvalue() {
        return Optional.ofNullable(applicablefromvalue);
    }

    public Slakpiinstance withApplicablefromvalue(OffsetDateTime applicablefromvalue) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("applicablefromvalue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.applicablefromvalue = applicablefromvalue;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Slakpiinstance withModifiedon(OffsetDateTime modifiedon) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Slakpiinstance withName(String name) {
        Checks.checkIsAscii(name);
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.name = name;
        return _x;
    }

    @Property(name="terminalstatetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getTerminalstatetime() {
        return Optional.ofNullable(terminalstatetime);
    }

    public Slakpiinstance withTerminalstatetime(OffsetDateTime terminalstatetime) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("terminalstatetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.terminalstatetime = terminalstatetime;
        return _x;
    }

    @Property(name="computedwarningtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getComputedwarningtime() {
        return Optional.ofNullable(computedwarningtime);
    }

    public Slakpiinstance withComputedwarningtime(OffsetDateTime computedwarningtime) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("computedwarningtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.computedwarningtime = computedwarningtime;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Slakpiinstance with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Slakpiinstance with_createdby_value(String _createdby_value) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Slakpiinstance withExchangerate(BigDecimal exchangerate) {
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="regardingentityid")
    @JsonIgnore
    public Optional<String> getRegardingentityid() {
        return Optional.ofNullable(regardingentityid);
    }

    public Slakpiinstance withRegardingentityid(String regardingentityid) {
        Checks.checkIsAscii(regardingentityid);
        Slakpiinstance _x = _copy();
        _x.changedFields = changedFields.add("regardingentityid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slakpiinstance");
        _x.regardingentityid = regardingentityid;
        return _x;
    }

    public Slakpiinstance withUnmappedField(String name, String value) {
        Slakpiinstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="regarding_letter")
    @JsonIgnore
    public LetterRequest getRegarding_letter() {
        return new LetterRequest(contextPath.addSegment("regarding_letter"), RequestHelper.getValue(unmappedFields, "regarding_letter"));
    }

    @NavigationProperty(name="regarding_task")
    @JsonIgnore
    public TaskRequest getRegarding_task() {
        return new TaskRequest(contextPath.addSegment("regarding_task"), RequestHelper.getValue(unmappedFields, "regarding_task"));
    }

    @NavigationProperty(name="regarding_email")
    @JsonIgnore
    public EmailRequest getRegarding_email() {
        return new EmailRequest(contextPath.addSegment("regarding_email"), RequestHelper.getValue(unmappedFields, "regarding_email"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="regarding_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getRegarding_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("regarding_socialactivity"), RequestHelper.getValue(unmappedFields, "regarding_socialactivity"));
    }

    @NavigationProperty(name="regarding_account")
    @JsonIgnore
    public AccountRequest getRegarding_account() {
        return new AccountRequest(contextPath.addSegment("regarding_account"), RequestHelper.getValue(unmappedFields, "regarding_account"));
    }

    @NavigationProperty(name="regarding_appointment")
    @JsonIgnore
    public AppointmentRequest getRegarding_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regarding_appointment"), RequestHelper.getValue(unmappedFields, "regarding_appointment"));
    }

    @NavigationProperty(name="regarding_contact")
    @JsonIgnore
    public ContactRequest getRegarding_contact() {
        return new ContactRequest(contextPath.addSegment("regarding_contact"), RequestHelper.getValue(unmappedFields, "regarding_contact"));
    }

    @NavigationProperty(name="regarding_fax")
    @JsonIgnore
    public FaxRequest getRegarding_fax() {
        return new FaxRequest(contextPath.addSegment("regarding_fax"), RequestHelper.getValue(unmappedFields, "regarding_fax"));
    }

    @NavigationProperty(name="regarding_phonecall")
    @JsonIgnore
    public PhonecallRequest getRegarding_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regarding_phonecall"), RequestHelper.getValue(unmappedFields, "regarding_phonecall"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="regarding_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getRegarding_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("regarding_activitypointer"), RequestHelper.getValue(unmappedFields, "regarding_activitypointer"));
    }

    @NavigationProperty(name="SLAKPIInstance_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSLAKPIInstance_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SLAKPIInstance_SyncErrors"), RequestHelper.getValue(unmappedFields, "SLAKPIInstance_SyncErrors"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="msdyn_slaitemid")
    @JsonIgnore
    public SlaitemRequest getMsdyn_slaitemid() {
        return new SlaitemRequest(contextPath.addSegment("msdyn_slaitemid"), RequestHelper.getValue(unmappedFields, "msdyn_slaitemid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Slakpiinstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Slakpiinstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Slakpiinstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Slakpiinstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Slakpiinstance _copy() {
        Slakpiinstance _x = new Slakpiinstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._ownerid_value = _ownerid_value;
        _x.slakpiinstanceid = slakpiinstanceid;
        _x.versionnumber = versionnumber;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.description = description;
        _x.lastresumetime = lastresumetime;
        _x.warningtime = warningtime;
        _x._owninguser_value = _owninguser_value;
        _x._owningteam_value = _owningteam_value;
        _x.pausedon = pausedon;
        _x.elapsedtime = elapsedtime;
        _x._msdyn_slaitemid_value = _msdyn_slaitemid_value;
        _x.msdyn_actionexecutionstatus = msdyn_actionexecutionstatus;
        _x.succeededon = succeededon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.computedfailuretime = computedfailuretime;
        _x.warningtimereached = warningtimereached;
        _x._modifiedby_value = _modifiedby_value;
        _x.msdyn_calendarid = msdyn_calendarid;
        _x.createdon = createdon;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.msdyn_prevslakpiinstanceid = msdyn_prevslakpiinstanceid;
        _x.failuretime = failuretime;
        _x.terminalstatereached = terminalstatereached;
        _x._regarding_value = _regarding_value;
        _x.status = status;
        _x.successcheckedat = successcheckedat;
        _x.applicablefromvalue = applicablefromvalue;
        _x.modifiedon = modifiedon;
        _x.name = name;
        _x.terminalstatetime = terminalstatetime;
        _x.computedwarningtime = computedwarningtime;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.exchangerate = exchangerate;
        _x.regardingentityid = regardingentityid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Slakpiinstance[");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("slakpiinstanceid=");
        b.append(this.slakpiinstanceid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("lastresumetime=");
        b.append(this.lastresumetime);
        b.append(", ");
        b.append("warningtime=");
        b.append(this.warningtime);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("pausedon=");
        b.append(this.pausedon);
        b.append(", ");
        b.append("elapsedtime=");
        b.append(this.elapsedtime);
        b.append(", ");
        b.append("_msdyn_slaitemid_value=");
        b.append(this._msdyn_slaitemid_value);
        b.append(", ");
        b.append("msdyn_actionexecutionstatus=");
        b.append(this.msdyn_actionexecutionstatus);
        b.append(", ");
        b.append("succeededon=");
        b.append(this.succeededon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("computedfailuretime=");
        b.append(this.computedfailuretime);
        b.append(", ");
        b.append("warningtimereached=");
        b.append(this.warningtimereached);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("msdyn_calendarid=");
        b.append(this.msdyn_calendarid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("msdyn_prevslakpiinstanceid=");
        b.append(this.msdyn_prevslakpiinstanceid);
        b.append(", ");
        b.append("failuretime=");
        b.append(this.failuretime);
        b.append(", ");
        b.append("terminalstatereached=");
        b.append(this.terminalstatereached);
        b.append(", ");
        b.append("_regarding_value=");
        b.append(this._regarding_value);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("successcheckedat=");
        b.append(this.successcheckedat);
        b.append(", ");
        b.append("applicablefromvalue=");
        b.append(this.applicablefromvalue);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("terminalstatetime=");
        b.append(this.terminalstatetime);
        b.append(", ");
        b.append("computedwarningtime=");
        b.append(this.computedwarningtime);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("regardingentityid=");
        b.append(this.regardingentityid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
