package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.LookupmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PicklistmappingCollectionRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedby_value", 
    "statuscode", 
    "sourceattributename", 
    "solutionid", 
    "introducedversion", 
    "componentstate", 
    "_createdby_value", 
    "_modifiedonbehalfby_value", 
    "overwritetime", 
    "statecode", 
    "ismanaged", 
    "columnmappingidunique", 
    "processcode", 
    "createdon", 
    "columnmappingid", 
    "_importmapid_value", 
    "modifiedon", 
    "targetattributename", 
    "_createdonbehalfby_value", 
    "sourceentityname", 
    "targetentityname"})
@JsonInclude(Include.NON_NULL)
public class Columnmapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.columnmapping";
    }

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("sourceattributename")
    protected String sourceattributename;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("columnmappingidunique")
    protected String columnmappingidunique;

    @JsonProperty("processcode")
    protected Integer processcode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("columnmappingid")
    protected String columnmappingid;

    @JsonProperty("_importmapid_value")
    protected String _importmapid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("targetattributename")
    protected String targetattributename;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("sourceentityname")
    protected String sourceentityname;

    @JsonProperty("targetentityname")
    protected String targetentityname;

    protected Columnmapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderColumnmapping() {
        return new Builder();
    }

    public static final class Builder {
        private String _modifiedby_value;
        private Integer statuscode;
        private String sourceattributename;
        private String solutionid;
        private String introducedversion;
        private Integer componentstate;
        private String _createdby_value;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime overwritetime;
        private Integer statecode;
        private Boolean ismanaged;
        private String columnmappingidunique;
        private Integer processcode;
        private OffsetDateTime createdon;
        private String columnmappingid;
        private String _importmapid_value;
        private OffsetDateTime modifiedon;
        private String targetattributename;
        private String _createdonbehalfby_value;
        private String sourceentityname;
        private String targetentityname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder sourceattributename(String sourceattributename) {
            this.sourceattributename = sourceattributename;
            this.changedFields = changedFields.add("sourceattributename");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder columnmappingidunique(String columnmappingidunique) {
            this.columnmappingidunique = columnmappingidunique;
            this.changedFields = changedFields.add("columnmappingidunique");
            return this;
        }

        public Builder processcode(Integer processcode) {
            this.processcode = processcode;
            this.changedFields = changedFields.add("processcode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder columnmappingid(String columnmappingid) {
            this.columnmappingid = columnmappingid;
            this.changedFields = changedFields.add("columnmappingid");
            return this;
        }

        public Builder _importmapid_value(String _importmapid_value) {
            this._importmapid_value = _importmapid_value;
            this.changedFields = changedFields.add("_importmapid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder targetattributename(String targetattributename) {
            this.targetattributename = targetattributename;
            this.changedFields = changedFields.add("targetattributename");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder sourceentityname(String sourceentityname) {
            this.sourceentityname = sourceentityname;
            this.changedFields = changedFields.add("sourceentityname");
            return this;
        }

        public Builder targetentityname(String targetentityname) {
            this.targetentityname = targetentityname;
            this.changedFields = changedFields.add("targetentityname");
            return this;
        }

        public Columnmapping build() {
            Columnmapping _x = new Columnmapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.columnmapping";
            _x._modifiedby_value = _modifiedby_value;
            _x.statuscode = statuscode;
            _x.sourceattributename = sourceattributename;
            _x.solutionid = solutionid;
            _x.introducedversion = introducedversion;
            _x.componentstate = componentstate;
            _x._createdby_value = _createdby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.overwritetime = overwritetime;
            _x.statecode = statecode;
            _x.ismanaged = ismanaged;
            _x.columnmappingidunique = columnmappingidunique;
            _x.processcode = processcode;
            _x.createdon = createdon;
            _x.columnmappingid = columnmappingid;
            _x._importmapid_value = _importmapid_value;
            _x.modifiedon = modifiedon;
            _x.targetattributename = targetattributename;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.sourceentityname = sourceentityname;
            _x.targetentityname = targetentityname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && columnmappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(columnmappingid.toString()));
        }
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Columnmapping with_modifiedby_value(String _modifiedby_value) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Columnmapping withStatuscode(Integer statuscode) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="sourceattributename")
    @JsonIgnore
    public Optional<String> getSourceattributename() {
        return Optional.ofNullable(sourceattributename);
    }

    public Columnmapping withSourceattributename(String sourceattributename) {
        Checks.checkIsAscii(sourceattributename);
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("sourceattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.sourceattributename = sourceattributename;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Columnmapping withSolutionid(String solutionid) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Columnmapping withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Columnmapping withComponentstate(Integer componentstate) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Columnmapping with_createdby_value(String _createdby_value) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Columnmapping with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Columnmapping withOverwritetime(OffsetDateTime overwritetime) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Columnmapping withStatecode(Integer statecode) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Columnmapping withIsmanaged(Boolean ismanaged) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="columnmappingidunique")
    @JsonIgnore
    public Optional<String> getColumnmappingidunique() {
        return Optional.ofNullable(columnmappingidunique);
    }

    public Columnmapping withColumnmappingidunique(String columnmappingidunique) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("columnmappingidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.columnmappingidunique = columnmappingidunique;
        return _x;
    }

    @Property(name="processcode")
    @JsonIgnore
    public Optional<Integer> getProcesscode() {
        return Optional.ofNullable(processcode);
    }

    public Columnmapping withProcesscode(Integer processcode) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("processcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.processcode = processcode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Columnmapping withCreatedon(OffsetDateTime createdon) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="columnmappingid")
    @JsonIgnore
    public Optional<String> getColumnmappingid() {
        return Optional.ofNullable(columnmappingid);
    }

    public Columnmapping withColumnmappingid(String columnmappingid) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("columnmappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.columnmappingid = columnmappingid;
        return _x;
    }

    @Property(name="_importmapid_value")
    @JsonIgnore
    public Optional<String> get_importmapid_value() {
        return Optional.ofNullable(_importmapid_value);
    }

    public Columnmapping with_importmapid_value(String _importmapid_value) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("_importmapid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x._importmapid_value = _importmapid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Columnmapping withModifiedon(OffsetDateTime modifiedon) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="targetattributename")
    @JsonIgnore
    public Optional<String> getTargetattributename() {
        return Optional.ofNullable(targetattributename);
    }

    public Columnmapping withTargetattributename(String targetattributename) {
        Checks.checkIsAscii(targetattributename);
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("targetattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.targetattributename = targetattributename;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Columnmapping with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="sourceentityname")
    @JsonIgnore
    public Optional<String> getSourceentityname() {
        return Optional.ofNullable(sourceentityname);
    }

    public Columnmapping withSourceentityname(String sourceentityname) {
        Checks.checkIsAscii(sourceentityname);
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("sourceentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.sourceentityname = sourceentityname;
        return _x;
    }

    @Property(name="targetentityname")
    @JsonIgnore
    public Optional<String> getTargetentityname() {
        return Optional.ofNullable(targetentityname);
    }

    public Columnmapping withTargetentityname(String targetentityname) {
        Checks.checkIsAscii(targetentityname);
        Columnmapping _x = _copy();
        _x.changedFields = changedFields.add("targetentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.columnmapping");
        _x.targetentityname = targetentityname;
        return _x;
    }

    public Columnmapping withUnmappedField(String name, String value) {
        Columnmapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="PickListMapping_ColumnMapping")
    @JsonIgnore
    public PicklistmappingCollectionRequest getPickListMapping_ColumnMapping() {
        return new PicklistmappingCollectionRequest(
                        contextPath.addSegment("PickListMapping_ColumnMapping"), RequestHelper.getValue(unmappedFields, "PickListMapping_ColumnMapping"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="importmapid")
    @JsonIgnore
    public ImportmapRequest getImportmapid() {
        return new ImportmapRequest(contextPath.addSegment("importmapid"), RequestHelper.getValue(unmappedFields, "importmapid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="LookUpMapping_ColumnMapping")
    @JsonIgnore
    public LookupmappingCollectionRequest getLookUpMapping_ColumnMapping() {
        return new LookupmappingCollectionRequest(
                        contextPath.addSegment("LookUpMapping_ColumnMapping"), RequestHelper.getValue(unmappedFields, "LookUpMapping_ColumnMapping"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Columnmapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Columnmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Columnmapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Columnmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Columnmapping _copy() {
        Columnmapping _x = new Columnmapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedby_value = _modifiedby_value;
        _x.statuscode = statuscode;
        _x.sourceattributename = sourceattributename;
        _x.solutionid = solutionid;
        _x.introducedversion = introducedversion;
        _x.componentstate = componentstate;
        _x._createdby_value = _createdby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.overwritetime = overwritetime;
        _x.statecode = statecode;
        _x.ismanaged = ismanaged;
        _x.columnmappingidunique = columnmappingidunique;
        _x.processcode = processcode;
        _x.createdon = createdon;
        _x.columnmappingid = columnmappingid;
        _x._importmapid_value = _importmapid_value;
        _x.modifiedon = modifiedon;
        _x.targetattributename = targetattributename;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.sourceentityname = sourceentityname;
        _x.targetentityname = targetentityname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Columnmapping[");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("sourceattributename=");
        b.append(this.sourceattributename);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("columnmappingidunique=");
        b.append(this.columnmappingidunique);
        b.append(", ");
        b.append("processcode=");
        b.append(this.processcode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("columnmappingid=");
        b.append(this.columnmappingid);
        b.append(", ");
        b.append("_importmapid_value=");
        b.append(this._importmapid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("targetattributename=");
        b.append(this.targetattributename);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("sourceentityname=");
        b.append(this.sourceentityname);
        b.append(", ");
        b.append("targetentityname=");
        b.append(this.targetentityname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
