package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "rank", 
    "createdon", 
    "starttime", 
    "groupdesignator", 
    "organizationid", 
    "isselected", 
    "duration", 
    "offset", 
    "timecode", 
    "_innercalendarid_value", 
    "modifiedon", 
    "extentcode", 
    "subcode", 
    "isvaried", 
    "effectiveintervalstart", 
    "name", 
    "endtime", 
    "_createdby_value", 
    "issimple", 
    "calendarruleid", 
    "timezonecode", 
    "pattern", 
    "effort", 
    "description", 
    "ismodified", 
    "_modifiedby_value", 
    "_calendarid_value", 
    "_modifiedonbehalfby_value", 
    "_createdonbehalfby_value", 
    "versionnumber", 
    "effectiveintervalend", 
    "businessunitid"})
@JsonInclude(Include.NON_NULL)
public class Calendarrule extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.calendarrule";
    }

    @JsonProperty("rank")
    protected Integer rank;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("starttime")
    protected OffsetDateTime starttime;

    @JsonProperty("groupdesignator")
    protected String groupdesignator;

    @JsonProperty("organizationid")
    protected String organizationid;

    @JsonProperty("isselected")
    protected Boolean isselected;

    @JsonProperty("duration")
    protected Integer duration;

    @JsonProperty("offset")
    protected Integer offset;

    @JsonProperty("timecode")
    protected Integer timecode;

    @JsonProperty("_innercalendarid_value")
    protected String _innercalendarid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("extentcode")
    protected Integer extentcode;

    @JsonProperty("subcode")
    protected Integer subcode;

    @JsonProperty("isvaried")
    protected Boolean isvaried;

    @JsonProperty("effectiveintervalstart")
    protected OffsetDateTime effectiveintervalstart;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("endtime")
    protected OffsetDateTime endtime;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("issimple")
    protected Boolean issimple;

    @JsonProperty("calendarruleid")
    protected String calendarruleid;

    @JsonProperty("timezonecode")
    protected Integer timezonecode;

    @JsonProperty("pattern")
    protected String pattern;

    @JsonProperty("effort")
    protected Double effort;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("ismodified")
    protected Boolean ismodified;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_calendarid_value")
    protected String _calendarid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("effectiveintervalend")
    protected OffsetDateTime effectiveintervalend;

    @JsonProperty("businessunitid")
    protected String businessunitid;

    protected Calendarrule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCalendarrule() {
        return new Builder();
    }

    public static final class Builder {
        private Integer rank;
        private OffsetDateTime createdon;
        private OffsetDateTime starttime;
        private String groupdesignator;
        private String organizationid;
        private Boolean isselected;
        private Integer duration;
        private Integer offset;
        private Integer timecode;
        private String _innercalendarid_value;
        private OffsetDateTime modifiedon;
        private Integer extentcode;
        private Integer subcode;
        private Boolean isvaried;
        private OffsetDateTime effectiveintervalstart;
        private String name;
        private OffsetDateTime endtime;
        private String _createdby_value;
        private Boolean issimple;
        private String calendarruleid;
        private Integer timezonecode;
        private String pattern;
        private Double effort;
        private String description;
        private Boolean ismodified;
        private String _modifiedby_value;
        private String _calendarid_value;
        private String _modifiedonbehalfby_value;
        private String _createdonbehalfby_value;
        private Long versionnumber;
        private OffsetDateTime effectiveintervalend;
        private String businessunitid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder rank(Integer rank) {
            this.rank = rank;
            this.changedFields = changedFields.add("rank");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder starttime(OffsetDateTime starttime) {
            this.starttime = starttime;
            this.changedFields = changedFields.add("starttime");
            return this;
        }

        public Builder groupdesignator(String groupdesignator) {
            this.groupdesignator = groupdesignator;
            this.changedFields = changedFields.add("groupdesignator");
            return this;
        }

        public Builder organizationid(String organizationid) {
            this.organizationid = organizationid;
            this.changedFields = changedFields.add("organizationid");
            return this;
        }

        public Builder isselected(Boolean isselected) {
            this.isselected = isselected;
            this.changedFields = changedFields.add("isselected");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            this.changedFields = changedFields.add("offset");
            return this;
        }

        public Builder timecode(Integer timecode) {
            this.timecode = timecode;
            this.changedFields = changedFields.add("timecode");
            return this;
        }

        public Builder _innercalendarid_value(String _innercalendarid_value) {
            this._innercalendarid_value = _innercalendarid_value;
            this.changedFields = changedFields.add("_innercalendarid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder extentcode(Integer extentcode) {
            this.extentcode = extentcode;
            this.changedFields = changedFields.add("extentcode");
            return this;
        }

        public Builder subcode(Integer subcode) {
            this.subcode = subcode;
            this.changedFields = changedFields.add("subcode");
            return this;
        }

        public Builder isvaried(Boolean isvaried) {
            this.isvaried = isvaried;
            this.changedFields = changedFields.add("isvaried");
            return this;
        }

        public Builder effectiveintervalstart(OffsetDateTime effectiveintervalstart) {
            this.effectiveintervalstart = effectiveintervalstart;
            this.changedFields = changedFields.add("effectiveintervalstart");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder endtime(OffsetDateTime endtime) {
            this.endtime = endtime;
            this.changedFields = changedFields.add("endtime");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder issimple(Boolean issimple) {
            this.issimple = issimple;
            this.changedFields = changedFields.add("issimple");
            return this;
        }

        public Builder calendarruleid(String calendarruleid) {
            this.calendarruleid = calendarruleid;
            this.changedFields = changedFields.add("calendarruleid");
            return this;
        }

        public Builder timezonecode(Integer timezonecode) {
            this.timezonecode = timezonecode;
            this.changedFields = changedFields.add("timezonecode");
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            this.changedFields = changedFields.add("pattern");
            return this;
        }

        public Builder effort(Double effort) {
            this.effort = effort;
            this.changedFields = changedFields.add("effort");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder ismodified(Boolean ismodified) {
            this.ismodified = ismodified;
            this.changedFields = changedFields.add("ismodified");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _calendarid_value(String _calendarid_value) {
            this._calendarid_value = _calendarid_value;
            this.changedFields = changedFields.add("_calendarid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder effectiveintervalend(OffsetDateTime effectiveintervalend) {
            this.effectiveintervalend = effectiveintervalend;
            this.changedFields = changedFields.add("effectiveintervalend");
            return this;
        }

        public Builder businessunitid(String businessunitid) {
            this.businessunitid = businessunitid;
            this.changedFields = changedFields.add("businessunitid");
            return this;
        }

        public Calendarrule build() {
            Calendarrule _x = new Calendarrule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.calendarrule";
            _x.rank = rank;
            _x.createdon = createdon;
            _x.starttime = starttime;
            _x.groupdesignator = groupdesignator;
            _x.organizationid = organizationid;
            _x.isselected = isselected;
            _x.duration = duration;
            _x.offset = offset;
            _x.timecode = timecode;
            _x._innercalendarid_value = _innercalendarid_value;
            _x.modifiedon = modifiedon;
            _x.extentcode = extentcode;
            _x.subcode = subcode;
            _x.isvaried = isvaried;
            _x.effectiveintervalstart = effectiveintervalstart;
            _x.name = name;
            _x.endtime = endtime;
            _x._createdby_value = _createdby_value;
            _x.issimple = issimple;
            _x.calendarruleid = calendarruleid;
            _x.timezonecode = timezonecode;
            _x.pattern = pattern;
            _x.effort = effort;
            _x.description = description;
            _x.ismodified = ismodified;
            _x._modifiedby_value = _modifiedby_value;
            _x._calendarid_value = _calendarid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x.effectiveintervalend = effectiveintervalend;
            _x.businessunitid = businessunitid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && calendarruleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(calendarruleid.toString()));
        }
    }

    @Property(name="rank")
    @JsonIgnore
    public Optional<Integer> getRank() {
        return Optional.ofNullable(rank);
    }

    public Calendarrule withRank(Integer rank) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("rank");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.rank = rank;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Calendarrule withCreatedon(OffsetDateTime createdon) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="starttime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStarttime() {
        return Optional.ofNullable(starttime);
    }

    public Calendarrule withStarttime(OffsetDateTime starttime) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("starttime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.starttime = starttime;
        return _x;
    }

    @Property(name="groupdesignator")
    @JsonIgnore
    public Optional<String> getGroupdesignator() {
        return Optional.ofNullable(groupdesignator);
    }

    public Calendarrule withGroupdesignator(String groupdesignator) {
        Checks.checkIsAscii(groupdesignator);
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("groupdesignator");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.groupdesignator = groupdesignator;
        return _x;
    }

    @Property(name="organizationid")
    @JsonIgnore
    public Optional<String> getOrganizationid() {
        return Optional.ofNullable(organizationid);
    }

    public Calendarrule withOrganizationid(String organizationid) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.organizationid = organizationid;
        return _x;
    }

    @Property(name="isselected")
    @JsonIgnore
    public Optional<Boolean> getIsselected() {
        return Optional.ofNullable(isselected);
    }

    public Calendarrule withIsselected(Boolean isselected) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("isselected");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.isselected = isselected;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Integer> getDuration() {
        return Optional.ofNullable(duration);
    }

    public Calendarrule withDuration(Integer duration) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.duration = duration;
        return _x;
    }

    @Property(name="offset")
    @JsonIgnore
    public Optional<Integer> getOffset() {
        return Optional.ofNullable(offset);
    }

    public Calendarrule withOffset(Integer offset) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("offset");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.offset = offset;
        return _x;
    }

    @Property(name="timecode")
    @JsonIgnore
    public Optional<Integer> getTimecode() {
        return Optional.ofNullable(timecode);
    }

    public Calendarrule withTimecode(Integer timecode) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("timecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.timecode = timecode;
        return _x;
    }

    @Property(name="_innercalendarid_value")
    @JsonIgnore
    public Optional<String> get_innercalendarid_value() {
        return Optional.ofNullable(_innercalendarid_value);
    }

    public Calendarrule with_innercalendarid_value(String _innercalendarid_value) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("_innercalendarid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x._innercalendarid_value = _innercalendarid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Calendarrule withModifiedon(OffsetDateTime modifiedon) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="extentcode")
    @JsonIgnore
    public Optional<Integer> getExtentcode() {
        return Optional.ofNullable(extentcode);
    }

    public Calendarrule withExtentcode(Integer extentcode) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("extentcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.extentcode = extentcode;
        return _x;
    }

    @Property(name="subcode")
    @JsonIgnore
    public Optional<Integer> getSubcode() {
        return Optional.ofNullable(subcode);
    }

    public Calendarrule withSubcode(Integer subcode) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("subcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.subcode = subcode;
        return _x;
    }

    @Property(name="isvaried")
    @JsonIgnore
    public Optional<Boolean> getIsvaried() {
        return Optional.ofNullable(isvaried);
    }

    public Calendarrule withIsvaried(Boolean isvaried) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("isvaried");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.isvaried = isvaried;
        return _x;
    }

    @Property(name="effectiveintervalstart")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectiveintervalstart() {
        return Optional.ofNullable(effectiveintervalstart);
    }

    public Calendarrule withEffectiveintervalstart(OffsetDateTime effectiveintervalstart) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("effectiveintervalstart");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.effectiveintervalstart = effectiveintervalstart;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Calendarrule withName(String name) {
        Checks.checkIsAscii(name);
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.name = name;
        return _x;
    }

    @Property(name="endtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndtime() {
        return Optional.ofNullable(endtime);
    }

    public Calendarrule withEndtime(OffsetDateTime endtime) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("endtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.endtime = endtime;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Calendarrule with_createdby_value(String _createdby_value) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="issimple")
    @JsonIgnore
    public Optional<Boolean> getIssimple() {
        return Optional.ofNullable(issimple);
    }

    public Calendarrule withIssimple(Boolean issimple) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("issimple");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.issimple = issimple;
        return _x;
    }

    @Property(name="calendarruleid")
    @JsonIgnore
    public Optional<String> getCalendarruleid() {
        return Optional.ofNullable(calendarruleid);
    }

    public Calendarrule withCalendarruleid(String calendarruleid) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("calendarruleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.calendarruleid = calendarruleid;
        return _x;
    }

    @Property(name="timezonecode")
    @JsonIgnore
    public Optional<Integer> getTimezonecode() {
        return Optional.ofNullable(timezonecode);
    }

    public Calendarrule withTimezonecode(Integer timezonecode) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("timezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.timezonecode = timezonecode;
        return _x;
    }

    @Property(name="pattern")
    @JsonIgnore
    public Optional<String> getPattern() {
        return Optional.ofNullable(pattern);
    }

    public Calendarrule withPattern(String pattern) {
        Checks.checkIsAscii(pattern);
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("pattern");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.pattern = pattern;
        return _x;
    }

    @Property(name="effort")
    @JsonIgnore
    public Optional<Double> getEffort() {
        return Optional.ofNullable(effort);
    }

    public Calendarrule withEffort(Double effort) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("effort");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.effort = effort;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Calendarrule withDescription(String description) {
        Checks.checkIsAscii(description);
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.description = description;
        return _x;
    }

    @Property(name="ismodified")
    @JsonIgnore
    public Optional<Boolean> getIsmodified() {
        return Optional.ofNullable(ismodified);
    }

    public Calendarrule withIsmodified(Boolean ismodified) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("ismodified");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.ismodified = ismodified;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Calendarrule with_modifiedby_value(String _modifiedby_value) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_calendarid_value")
    @JsonIgnore
    public Optional<String> get_calendarid_value() {
        return Optional.ofNullable(_calendarid_value);
    }

    public Calendarrule with_calendarid_value(String _calendarid_value) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("_calendarid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x._calendarid_value = _calendarid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Calendarrule with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Calendarrule with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Calendarrule withVersionnumber(Long versionnumber) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="effectiveintervalend")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectiveintervalend() {
        return Optional.ofNullable(effectiveintervalend);
    }

    public Calendarrule withEffectiveintervalend(OffsetDateTime effectiveintervalend) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("effectiveintervalend");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.effectiveintervalend = effectiveintervalend;
        return _x;
    }

    @Property(name="businessunitid")
    @JsonIgnore
    public Optional<String> getBusinessunitid() {
        return Optional.ofNullable(businessunitid);
    }

    public Calendarrule withBusinessunitid(String businessunitid) {
        Calendarrule _x = _copy();
        _x.changedFields = changedFields.add("businessunitid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendarrule");
        _x.businessunitid = businessunitid;
        return _x;
    }

    public Calendarrule withUnmappedField(String name, String value) {
        Calendarrule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="calendarid")
    @JsonIgnore
    public CalendarRequest getCalendarid() {
        return new CalendarRequest(contextPath.addSegment("calendarid"), RequestHelper.getValue(unmappedFields, "calendarid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="innercalendarid")
    @JsonIgnore
    public CalendarRequest getInnercalendarid() {
        return new CalendarRequest(contextPath.addSegment("innercalendarid"), RequestHelper.getValue(unmappedFields, "innercalendarid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Calendarrule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Calendarrule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Calendarrule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Calendarrule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Calendarrule _copy() {
        Calendarrule _x = new Calendarrule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.rank = rank;
        _x.createdon = createdon;
        _x.starttime = starttime;
        _x.groupdesignator = groupdesignator;
        _x.organizationid = organizationid;
        _x.isselected = isselected;
        _x.duration = duration;
        _x.offset = offset;
        _x.timecode = timecode;
        _x._innercalendarid_value = _innercalendarid_value;
        _x.modifiedon = modifiedon;
        _x.extentcode = extentcode;
        _x.subcode = subcode;
        _x.isvaried = isvaried;
        _x.effectiveintervalstart = effectiveintervalstart;
        _x.name = name;
        _x.endtime = endtime;
        _x._createdby_value = _createdby_value;
        _x.issimple = issimple;
        _x.calendarruleid = calendarruleid;
        _x.timezonecode = timezonecode;
        _x.pattern = pattern;
        _x.effort = effort;
        _x.description = description;
        _x.ismodified = ismodified;
        _x._modifiedby_value = _modifiedby_value;
        _x._calendarid_value = _calendarid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x.effectiveintervalend = effectiveintervalend;
        _x.businessunitid = businessunitid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Calendarrule[");
        b.append("rank=");
        b.append(this.rank);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("starttime=");
        b.append(this.starttime);
        b.append(", ");
        b.append("groupdesignator=");
        b.append(this.groupdesignator);
        b.append(", ");
        b.append("organizationid=");
        b.append(this.organizationid);
        b.append(", ");
        b.append("isselected=");
        b.append(this.isselected);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("offset=");
        b.append(this.offset);
        b.append(", ");
        b.append("timecode=");
        b.append(this.timecode);
        b.append(", ");
        b.append("_innercalendarid_value=");
        b.append(this._innercalendarid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("extentcode=");
        b.append(this.extentcode);
        b.append(", ");
        b.append("subcode=");
        b.append(this.subcode);
        b.append(", ");
        b.append("isvaried=");
        b.append(this.isvaried);
        b.append(", ");
        b.append("effectiveintervalstart=");
        b.append(this.effectiveintervalstart);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("endtime=");
        b.append(this.endtime);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("issimple=");
        b.append(this.issimple);
        b.append(", ");
        b.append("calendarruleid=");
        b.append(this.calendarruleid);
        b.append(", ");
        b.append("timezonecode=");
        b.append(this.timezonecode);
        b.append(", ");
        b.append("pattern=");
        b.append(this.pattern);
        b.append(", ");
        b.append("effort=");
        b.append(this.effort);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("ismodified=");
        b.append(this.ismodified);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_calendarid_value=");
        b.append(this._calendarid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("effectiveintervalend=");
        b.append(this.effectiveintervalend);
        b.append(", ");
        b.append("businessunitid=");
        b.append(this.businessunitid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
