package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ResourceId", 
    "ResourceSpecId", 
    "DisplayName", 
    "EntityName", 
    "EffortRequired"})
@JsonInclude(Include.NON_NULL)
public class ProposalParty implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ResourceId")
    protected String resourceId;

    @JsonProperty("ResourceSpecId")
    protected String resourceSpecId;

    @JsonProperty("DisplayName")
    protected String displayName;

    @JsonProperty("EntityName")
    protected String entityName;

    @JsonProperty("EffortRequired")
    protected Double effortRequired;

    protected ProposalParty() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ProposalParty";
    }

    @Property(name="ResourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public ProposalParty withResourceId(String resourceId) {
        ProposalParty _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ProposalParty");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="ResourceSpecId")
    @JsonIgnore
    public Optional<String> getResourceSpecId() {
        return Optional.ofNullable(resourceSpecId);
    }

    public ProposalParty withResourceSpecId(String resourceSpecId) {
        ProposalParty _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ProposalParty");
        _x.resourceSpecId = resourceSpecId;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ProposalParty withDisplayName(String displayName) {
        Checks.checkIsAscii(displayName);
        ProposalParty _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ProposalParty");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(entityName);
    }

    public ProposalParty withEntityName(String entityName) {
        Checks.checkIsAscii(entityName);
        ProposalParty _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ProposalParty");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="EffortRequired")
    @JsonIgnore
    public Optional<Double> getEffortRequired() {
        return Optional.ofNullable(effortRequired);
    }

    public ProposalParty withEffortRequired(Double effortRequired) {
        ProposalParty _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ProposalParty");
        _x.effortRequired = effortRequired;
        return _x;
    }

    public ProposalParty withUnmappedField(String name, String value) {
        ProposalParty _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String resourceId;
        private String resourceSpecId;
        private String displayName;
        private String entityName;
        private Double effortRequired;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("ResourceId");
            return this;
        }

        public Builder resourceSpecId(String resourceSpecId) {
            this.resourceSpecId = resourceSpecId;
            this.changedFields = changedFields.add("ResourceSpecId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = changedFields.add("EntityName");
            return this;
        }

        public Builder effortRequired(Double effortRequired) {
            this.effortRequired = effortRequired;
            this.changedFields = changedFields.add("EffortRequired");
            return this;
        }

        public ProposalParty build() {
            ProposalParty _x = new ProposalParty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ProposalParty";
            _x.resourceId = resourceId;
            _x.resourceSpecId = resourceSpecId;
            _x.displayName = displayName;
            _x.entityName = entityName;
            _x.effortRequired = effortRequired;
            return _x;
        }
    }

    private ProposalParty _copy() {
        ProposalParty _x = new ProposalParty();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resourceId = resourceId;
        _x.resourceSpecId = resourceSpecId;
        _x.displayName = displayName;
        _x.entityName = entityName;
        _x.effortRequired = effortRequired;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProposalParty[");
        b.append("ResourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("ResourceSpecId=");
        b.append(this.resourceSpecId);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("EffortRequired=");
        b.append(this.effortRequired);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
