package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Value", 
    "Label", 
    "Description", 
    "Color", 
    "IsManaged", 
    "ExternalValue", 
    "ParentValues", 
    "MetadataId", 
    "HasChanged"})
@JsonInclude(Include.NON_NULL)
public class OptionMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Value")
    protected Integer value;

    @JsonProperty("Label")
    protected Label label;

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("Color")
    protected String color;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("ExternalValue")
    protected String externalValue;

    @JsonProperty("ParentValues")
    protected List<Integer> parentValues;

    @JsonProperty("ParentValues@nextLink")
    protected String parentValuesNextLink;

    @JsonProperty("MetadataId")
    protected String metadataId;

    @JsonProperty("HasChanged")
    protected Boolean hasChanged;

    protected OptionMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OptionMetadata";
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<Integer> getValue() {
        return Optional.ofNullable(value);
    }

    public OptionMetadata withValue(Integer value) {
        OptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionMetadata");
        _x.value = value;
        return _x;
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<Label> getLabel() {
        return Optional.ofNullable(label);
    }

    public OptionMetadata withLabel(Label label) {
        OptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionMetadata");
        _x.label = label;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public OptionMetadata withDescription(Label description) {
        OptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="Color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public OptionMetadata withColor(String color) {
        Checks.checkIsAscii(color);
        OptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionMetadata");
        _x.color = color;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public OptionMetadata withIsManaged(Boolean isManaged) {
        OptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="ExternalValue")
    @JsonIgnore
    public Optional<String> getExternalValue() {
        return Optional.ofNullable(externalValue);
    }

    public OptionMetadata withExternalValue(String externalValue) {
        Checks.checkIsAscii(externalValue);
        OptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionMetadata");
        _x.externalValue = externalValue;
        return _x;
    }

    @Property(name="ParentValues")
    @JsonIgnore
    public CollectionPage<Integer> getParentValues() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.parentValues, Optional.ofNullable(parentValuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ParentValues")
    @JsonIgnore
    public CollectionPage<Integer> getParentValues(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.parentValues, Optional.ofNullable(parentValuesNextLink), Collections.emptyList(), options);
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<String> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public OptionMetadata withMetadataId(String metadataId) {
        OptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionMetadata");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(hasChanged);
    }

    public OptionMetadata withHasChanged(Boolean hasChanged) {
        OptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionMetadata");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public OptionMetadata withUnmappedField(String name, String value) {
        OptionMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer value;
        private Label label;
        private Label description;
        private String color;
        private Boolean isManaged;
        private String externalValue;
        private List<Integer> parentValues;
        private String parentValuesNextLink;
        private String metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public Builder label(Label label) {
            this.label = label;
            this.changedFields = changedFields.add("Label");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("Color");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder externalValue(String externalValue) {
            this.externalValue = externalValue;
            this.changedFields = changedFields.add("ExternalValue");
            return this;
        }

        public Builder parentValues(List<Integer> parentValues) {
            this.parentValues = parentValues;
            this.changedFields = changedFields.add("ParentValues");
            return this;
        }

        public Builder parentValues(Integer... parentValues) {
            return parentValues(Arrays.asList(parentValues));
        }

        public Builder parentValuesNextLink(String parentValuesNextLink) {
            this.parentValuesNextLink = parentValuesNextLink;
            this.changedFields = changedFields.add("ParentValues");
            return this;
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public OptionMetadata build() {
            OptionMetadata _x = new OptionMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OptionMetadata";
            _x.value = value;
            _x.label = label;
            _x.description = description;
            _x.color = color;
            _x.isManaged = isManaged;
            _x.externalValue = externalValue;
            _x.parentValues = parentValues;
            _x.parentValuesNextLink = parentValuesNextLink;
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            return _x;
        }
    }

    private OptionMetadata _copy() {
        OptionMetadata _x = new OptionMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.value = value;
        _x.label = label;
        _x.description = description;
        _x.color = color;
        _x.isManaged = isManaged;
        _x.externalValue = externalValue;
        _x.parentValues = parentValues;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OptionMetadata[");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("Color=");
        b.append(this.color);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("ExternalValue=");
        b.append(this.externalValue);
        b.append(", ");
        b.append("ParentValues=");
        b.append(this.parentValues);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
