package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "RuleId"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_RegisterSolutionHealthRuleResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RuleId")
    protected String ruleId;

    protected Msdyn_RegisterSolutionHealthRuleResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_RegisterSolutionHealthRuleResponse";
    }

    @Property(name="RuleId")
    @JsonIgnore
    public Optional<String> getRuleId() {
        return Optional.ofNullable(ruleId);
    }

    public Msdyn_RegisterSolutionHealthRuleResponse withRuleId(String ruleId) {
        Checks.checkIsAscii(ruleId);
        Msdyn_RegisterSolutionHealthRuleResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_RegisterSolutionHealthRuleResponse");
        _x.ruleId = ruleId;
        return _x;
    }

    public Msdyn_RegisterSolutionHealthRuleResponse withUnmappedField(String name, String value) {
        Msdyn_RegisterSolutionHealthRuleResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ruleId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            this.changedFields = changedFields.add("RuleId");
            return this;
        }

        public Msdyn_RegisterSolutionHealthRuleResponse build() {
            Msdyn_RegisterSolutionHealthRuleResponse _x = new Msdyn_RegisterSolutionHealthRuleResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_RegisterSolutionHealthRuleResponse";
            _x.ruleId = ruleId;
            return _x;
        }
    }

    private Msdyn_RegisterSolutionHealthRuleResponse _copy() {
        Msdyn_RegisterSolutionHealthRuleResponse _x = new Msdyn_RegisterSolutionHealthRuleResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ruleId = ruleId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_RegisterSolutionHealthRuleResponse[");
        b.append("RuleId=");
        b.append(this.ruleId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
