package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Message", 
    "ResultEntities", 
    "ReturnStatus", 
    "ReturnSeverity", 
    "ReturnLevel"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_CheckForCustomizedSitemapResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Message")
    protected String message;

    @JsonProperty("ResultEntities")
    protected String resultEntities;

    @JsonProperty("ReturnStatus")
    protected Integer returnStatus;

    @JsonProperty("ReturnSeverity")
    protected Integer returnSeverity;

    @JsonProperty("ReturnLevel")
    protected Integer returnLevel;

    protected Msdyn_CheckForCustomizedSitemapResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemapResponse";
    }

    @Property(name="Message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public Msdyn_CheckForCustomizedSitemapResponse withMessage(String message) {
        Checks.checkIsAscii(message);
        Msdyn_CheckForCustomizedSitemapResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemapResponse");
        _x.message = message;
        return _x;
    }

    @Property(name="ResultEntities")
    @JsonIgnore
    public Optional<String> getResultEntities() {
        return Optional.ofNullable(resultEntities);
    }

    public Msdyn_CheckForCustomizedSitemapResponse withResultEntities(String resultEntities) {
        Checks.checkIsAscii(resultEntities);
        Msdyn_CheckForCustomizedSitemapResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemapResponse");
        _x.resultEntities = resultEntities;
        return _x;
    }

    @Property(name="ReturnStatus")
    @JsonIgnore
    public Optional<Integer> getReturnStatus() {
        return Optional.ofNullable(returnStatus);
    }

    public Msdyn_CheckForCustomizedSitemapResponse withReturnStatus(Integer returnStatus) {
        Msdyn_CheckForCustomizedSitemapResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemapResponse");
        _x.returnStatus = returnStatus;
        return _x;
    }

    @Property(name="ReturnSeverity")
    @JsonIgnore
    public Optional<Integer> getReturnSeverity() {
        return Optional.ofNullable(returnSeverity);
    }

    public Msdyn_CheckForCustomizedSitemapResponse withReturnSeverity(Integer returnSeverity) {
        Msdyn_CheckForCustomizedSitemapResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemapResponse");
        _x.returnSeverity = returnSeverity;
        return _x;
    }

    @Property(name="ReturnLevel")
    @JsonIgnore
    public Optional<Integer> getReturnLevel() {
        return Optional.ofNullable(returnLevel);
    }

    public Msdyn_CheckForCustomizedSitemapResponse withReturnLevel(Integer returnLevel) {
        Msdyn_CheckForCustomizedSitemapResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemapResponse");
        _x.returnLevel = returnLevel;
        return _x;
    }

    public Msdyn_CheckForCustomizedSitemapResponse withUnmappedField(String name, String value) {
        Msdyn_CheckForCustomizedSitemapResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String message;
        private String resultEntities;
        private Integer returnStatus;
        private Integer returnSeverity;
        private Integer returnLevel;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("Message");
            return this;
        }

        public Builder resultEntities(String resultEntities) {
            this.resultEntities = resultEntities;
            this.changedFields = changedFields.add("ResultEntities");
            return this;
        }

        public Builder returnStatus(Integer returnStatus) {
            this.returnStatus = returnStatus;
            this.changedFields = changedFields.add("ReturnStatus");
            return this;
        }

        public Builder returnSeverity(Integer returnSeverity) {
            this.returnSeverity = returnSeverity;
            this.changedFields = changedFields.add("ReturnSeverity");
            return this;
        }

        public Builder returnLevel(Integer returnLevel) {
            this.returnLevel = returnLevel;
            this.changedFields = changedFields.add("ReturnLevel");
            return this;
        }

        public Msdyn_CheckForCustomizedSitemapResponse build() {
            Msdyn_CheckForCustomizedSitemapResponse _x = new Msdyn_CheckForCustomizedSitemapResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_CheckForCustomizedSitemapResponse";
            _x.message = message;
            _x.resultEntities = resultEntities;
            _x.returnStatus = returnStatus;
            _x.returnSeverity = returnSeverity;
            _x.returnLevel = returnLevel;
            return _x;
        }
    }

    private Msdyn_CheckForCustomizedSitemapResponse _copy() {
        Msdyn_CheckForCustomizedSitemapResponse _x = new Msdyn_CheckForCustomizedSitemapResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.message = message;
        _x.resultEntities = resultEntities;
        _x.returnStatus = returnStatus;
        _x.returnSeverity = returnSeverity;
        _x.returnLevel = returnLevel;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_CheckForCustomizedSitemapResponse[");
        b.append("Message=");
        b.append(this.message);
        b.append(", ");
        b.append("ResultEntities=");
        b.append(this.resultEntities);
        b.append(", ");
        b.append("ReturnStatus=");
        b.append(this.returnStatus);
        b.append(", ");
        b.append("ReturnSeverity=");
        b.append(this.returnSeverity);
        b.append(", ");
        b.append("ReturnLevel=");
        b.append(this.returnLevel);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
