package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ObjectId", 
    "ConstraintType", 
    "Constraints"})
@JsonInclude(Include.NON_NULL)
public class ConstraintRelation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ObjectId")
    protected String objectId;

    @JsonProperty("ConstraintType")
    protected String constraintType;

    @JsonProperty("Constraints")
    protected String constraints;

    protected ConstraintRelation() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ConstraintRelation";
    }

    @Property(name="ObjectId")
    @JsonIgnore
    public Optional<String> getObjectId() {
        return Optional.ofNullable(objectId);
    }

    public ConstraintRelation withObjectId(String objectId) {
        ConstraintRelation _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ConstraintRelation");
        _x.objectId = objectId;
        return _x;
    }

    @Property(name="ConstraintType")
    @JsonIgnore
    public Optional<String> getConstraintType() {
        return Optional.ofNullable(constraintType);
    }

    public ConstraintRelation withConstraintType(String constraintType) {
        Checks.checkIsAscii(constraintType);
        ConstraintRelation _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ConstraintRelation");
        _x.constraintType = constraintType;
        return _x;
    }

    @Property(name="Constraints")
    @JsonIgnore
    public Optional<String> getConstraints() {
        return Optional.ofNullable(constraints);
    }

    public ConstraintRelation withConstraints(String constraints) {
        Checks.checkIsAscii(constraints);
        ConstraintRelation _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ConstraintRelation");
        _x.constraints = constraints;
        return _x;
    }

    public ConstraintRelation withUnmappedField(String name, String value) {
        ConstraintRelation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String objectId;
        private String constraintType;
        private String constraints;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.changedFields = changedFields.add("ObjectId");
            return this;
        }

        public Builder constraintType(String constraintType) {
            this.constraintType = constraintType;
            this.changedFields = changedFields.add("ConstraintType");
            return this;
        }

        public Builder constraints(String constraints) {
            this.constraints = constraints;
            this.changedFields = changedFields.add("Constraints");
            return this;
        }

        public ConstraintRelation build() {
            ConstraintRelation _x = new ConstraintRelation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ConstraintRelation";
            _x.objectId = objectId;
            _x.constraintType = constraintType;
            _x.constraints = constraints;
            return _x;
        }
    }

    private ConstraintRelation _copy() {
        ConstraintRelation _x = new ConstraintRelation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.objectId = objectId;
        _x.constraintType = constraintType;
        _x.constraints = constraints;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConstraintRelation[");
        b.append("ObjectId=");
        b.append(this.objectId);
        b.append(", ");
        b.append("ConstraintType=");
        b.append(this.constraintType);
        b.append(", ");
        b.append("Constraints=");
        b.append(this.constraints);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
