package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ShouldPromote", 
    "ReasonCode"})
@JsonInclude(Include.NON_NULL)
public class CheckPromoteEmailResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ShouldPromote")
    protected Boolean shouldPromote;

    @JsonProperty("ReasonCode")
    protected Integer reasonCode;

    protected CheckPromoteEmailResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.CheckPromoteEmailResponse";
    }

    @Property(name="ShouldPromote")
    @JsonIgnore
    public Optional<Boolean> getShouldPromote() {
        return Optional.ofNullable(shouldPromote);
    }

    public CheckPromoteEmailResponse withShouldPromote(Boolean shouldPromote) {
        CheckPromoteEmailResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CheckPromoteEmailResponse");
        _x.shouldPromote = shouldPromote;
        return _x;
    }

    @Property(name="ReasonCode")
    @JsonIgnore
    public Optional<Integer> getReasonCode() {
        return Optional.ofNullable(reasonCode);
    }

    public CheckPromoteEmailResponse withReasonCode(Integer reasonCode) {
        CheckPromoteEmailResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.CheckPromoteEmailResponse");
        _x.reasonCode = reasonCode;
        return _x;
    }

    public CheckPromoteEmailResponse withUnmappedField(String name, String value) {
        CheckPromoteEmailResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean shouldPromote;
        private Integer reasonCode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder shouldPromote(Boolean shouldPromote) {
            this.shouldPromote = shouldPromote;
            this.changedFields = changedFields.add("ShouldPromote");
            return this;
        }

        public Builder reasonCode(Integer reasonCode) {
            this.reasonCode = reasonCode;
            this.changedFields = changedFields.add("ReasonCode");
            return this;
        }

        public CheckPromoteEmailResponse build() {
            CheckPromoteEmailResponse _x = new CheckPromoteEmailResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.CheckPromoteEmailResponse";
            _x.shouldPromote = shouldPromote;
            _x.reasonCode = reasonCode;
            return _x;
        }
    }

    private CheckPromoteEmailResponse _copy() {
        CheckPromoteEmailResponse _x = new CheckPromoteEmailResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.shouldPromote = shouldPromote;
        _x.reasonCode = reasonCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CheckPromoteEmailResponse[");
        b.append("ShouldPromote=");
        b.append(this.shouldPromote);
        b.append(", ");
        b.append("ReasonCode=");
        b.append(this.reasonCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
