package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Usermapping;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;

@JsonIgnoreType
public class UsermappingRequest extends EntityRequest<Usermapping> {

    public UsermappingRequest(ContextPath contextPath, Optional<Object> value) {
        super(Usermapping.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public AsyncoperationCollectionRequest usermapping_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("usermapping_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest usermapping_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("usermapping_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest usermapping_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("usermapping_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest usermapping_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("usermapping_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest usermapping_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("usermapping_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest usermapping_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("usermapping_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

}
