package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Queueitem;
import microsoft.dynamics.crm.entity.Systemuser;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class QueueitemRequest extends EntityRequest<Queueitem> {

    public QueueitemRequest(ContextPath contextPath, Optional<Object> value) {
        super(Queueitem.class, contextPath, value, false);
    }

    public KnowledgearticleRequest objectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("objectid_knowledgearticle"), Optional.empty());
    }

    public ProcesssessionCollectionRequest queueItem_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("QueueItem_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest queueItem_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("QueueItem_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public AppointmentRequest objectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("objectid_appointment"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest workerid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("workerid_systemuser"), Optional.empty());
    }

    public ActivitypointerRequest objectid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("objectid_activitypointer"), Optional.empty());
    }

    public QueueRequest queueid() {
        return new QueueRequest(contextPath.addSegment("queueid"), Optional.empty());
    }

    public AsyncoperationCollectionRequest queueItem_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("QueueItem_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest queueItem_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("QueueItem_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public TeamRequest workerid_team() {
        return new TeamRequest(contextPath.addSegment("workerid_team"), Optional.empty());
    }

    public FaxRequest objectid_fax() {
        return new FaxRequest(contextPath.addSegment("objectid_fax"), Optional.empty());
    }

    public RecurringappointmentmasterRequest objectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("objectid_recurringappointmentmaster"), Optional.empty());
    }

    public SyncerrorCollectionRequest queueItem_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("QueueItem_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest queueItem_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("QueueItem_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public LetterRequest objectid_letter() {
        return new LetterRequest(contextPath.addSegment("objectid_letter"), Optional.empty());
    }

    public SocialactivityRequest objectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("objectid_socialactivity"), Optional.empty());
    }

    public PhonecallRequest objectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("objectid_phonecall"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public TaskRequest objectid_task() {
        return new TaskRequest(contextPath.addSegment("objectid_task"), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest queueitem_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("queueitem_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest queueitem_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("queueitem_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest queueItem_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("QueueItem_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest queueItem_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("QueueItem_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public EmailRequest objectid_email() {
        return new EmailRequest(contextPath.addSegment("objectid_email"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest objectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("objectid_msdyn_knowledgearticletemplate"), Optional.empty());
    }

    @Action(name = "PickFromQueue")
    @JsonIgnore
    public ActionRequestNoReturn pickFromQueue(Systemuser systemUser, Boolean removeQueueItem) {
        Preconditions.checkNotNull(systemUser, "systemUser cannot be null");
        Preconditions.checkNotNull(removeQueueItem, "removeQueueItem cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SystemUser", "Microsoft.Dynamics.CRM.systemuser", systemUser)
            .put("RemoveQueueItem", "Edm.Boolean", removeQueueItem)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PickFromQueue"), _parameters);
    }

    @Action(name = "ReleaseToQueue")
    @JsonIgnore
    public ActionRequestNoReturn releaseToQueue() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ReleaseToQueue"), _parameters);
    }

    @Action(name = "RemoveFromQueue")
    @JsonIgnore
    public ActionRequestNoReturn removeFromQueue() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveFromQueue"), _parameters);
    }

}
