package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Processtrigger;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ProcesstriggerRequest extends EntityRequest<Processtrigger> {

    public ProcesstriggerRequest(ContextPath contextPath, Optional<Object> value) {
        super(Processtrigger.class, contextPath, value, false);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SyncerrorCollectionRequest processTrigger_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ProcessTrigger_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest processTrigger_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ProcessTrigger_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SystemformRequest formid() {
        return new SystemformRequest(contextPath.addSegment("formid"), Optional.empty());
    }

    public WorkflowRequest processid() {
        return new WorkflowRequest(contextPath.addSegment("processid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

}
