package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Msdyn_aibdatasetscontainer;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class Msdyn_aibdatasetscontainerRequest extends EntityRequest<Msdyn_aibdatasetscontainer> {

    public Msdyn_aibdatasetscontainerRequest(ContextPath contextPath, Optional<Object> value) {
        super(Msdyn_aibdatasetscontainer.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aibdatasetscontainer_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest msdyn_aibdatasetscontainer_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdatasetscontainer_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdatasetscontainer_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdatasetscontainer_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdatasetscontainer_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aibdatasetscontainer_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aibdatasetscontainer_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aibdatasetscontainer_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aibdatasetscontainer_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aibdatasetscontainer_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aibdatasetscontainer_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aibdatasetscontainer_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aibdatasetscontainer_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aibdatasetscontainer_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest msdyn_AIBDataset_msdyn_AIBDatasetsContain() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("msdyn_AIBDataset_msdyn_AIBDatasetsContain"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest msdyn_AIBDataset_msdyn_AIBDatasetsContain(String msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("msdyn_AIBDataset_msdyn_AIBDatasetsContain").addKeys(new NameValue(msdyn_aibdatasetid.toString())), Optional.empty());
    }

    public Msdyn_aimodelRequest msdyn_AIModelId() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("msdyn_AIModelId"), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest msdyn_AIBFile_msdyn_AIBDatasetsCont() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("msdyn_AIBFile_msdyn_AIBDatasetsCont"), Optional.empty());
    }

    public Msdyn_aibfileRequest msdyn_AIBFile_msdyn_AIBDatasetsCont(String msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("msdyn_AIBFile_msdyn_AIBDatasetsCont").addKeys(new NameValue(msdyn_aibfileid.toString())), Optional.empty());
    }

}
