package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Mailbox;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TracelogCollectionRequest;

@JsonIgnoreType
public class MailboxRequest extends EntityRequest<Mailbox> {

    public MailboxRequest(ContextPath contextPath, Optional<Object> value) {
        super(Mailbox.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SystemuserRequest regardingobjectid() {
        return new SystemuserRequest(contextPath.addSegment("regardingobjectid"), Optional.empty());
    }

    public EmailserverprofileRequest emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("emailserverprofile"), Optional.empty());
    }

    public SystemuserCollectionRequest systemuser_defaultmailbox_mailbox() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("systemuser_defaultmailbox_mailbox"), Optional.empty());
    }

    public SystemuserRequest systemuser_defaultmailbox_mailbox(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("systemuser_defaultmailbox_mailbox").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public QueueCollectionRequest queue_defaultmailbox_mailbox() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("queue_defaultmailbox_mailbox"), Optional.empty());
    }

    public QueueRequest queue_defaultmailbox_mailbox(String queueid) {
        return new QueueRequest(contextPath.addSegment("queue_defaultmailbox_mailbox").addKeys(new NameValue(queueid.toString())), Optional.empty());
    }

    public TracelogCollectionRequest tracelog_Mailbox() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("tracelog_Mailbox"), Optional.empty());
    }

    public TracelogRequest tracelog_Mailbox(String tracelogid) {
        return new TracelogRequest(contextPath.addSegment("tracelog_Mailbox").addKeys(new NameValue(tracelogid.toString())), Optional.empty());
    }

    public ActivitypointerCollectionRequest activitypointer_sendermailboxid_mailbox() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("activitypointer_sendermailboxid_mailbox"), Optional.empty());
    }

    public ActivitypointerRequest activitypointer_sendermailboxid_mailbox(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("activitypointer_sendermailboxid_mailbox").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest mailbox_asyncoperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("mailbox_asyncoperations"), Optional.empty());
    }

    public AsyncoperationRequest mailbox_asyncoperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("mailbox_asyncoperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public QueueRequest regardingobjectid_queue() {
        return new QueueRequest(contextPath.addSegment("regardingobjectid_queue"), Optional.empty());
    }

    public EmailCollectionRequest email_sendermailboxid_mailbox() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("email_sendermailboxid_mailbox"), Optional.empty());
    }

    public EmailRequest email_sendermailboxid_mailbox(String activityid) {
        return new EmailRequest(contextPath.addSegment("email_sendermailboxid_mailbox").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest mailbox_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Mailbox_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest mailbox_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Mailbox_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest mailbox_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Mailbox_Annotation"), Optional.empty());
    }

    public AnnotationRequest mailbox_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Mailbox_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest mailbox_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("Mailbox_MailboxTrackingFolder"), Optional.empty());
    }

    public MailboxtrackingfolderRequest mailbox_MailboxTrackingFolder(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("Mailbox_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public ProcesssessionCollectionRequest mailbox_processsessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("mailbox_processsessions"), Optional.empty());
    }

    public ProcesssessionRequest mailbox_processsessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("mailbox_processsessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

}
