package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Languagelocale;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;

@JsonIgnoreType
public class LanguagelocaleRequest extends EntityRequest<Languagelocale> {

    public LanguagelocaleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Languagelocale.class, contextPath, value, false);
    }

    public KnowledgearticleCollectionRequest knowledgearticle_languagelocaleid() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("knowledgearticle_languagelocaleid"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticle_languagelocaleid(String knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticle_languagelocaleid").addKeys(new NameValue(knowledgearticleid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

}
