package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Entityrelationship;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentrelationshipconfigurationCollectionRequest;

@JsonIgnoreType
public class EntityrelationshipRequest extends EntityRequest<Entityrelationship> {

    public EntityrelationshipRequest(ContextPath contextPath, Optional<Object> value) {
        super(Entityrelationship.class, contextPath, value, false);
    }

    public SolutioncomponentrelationshipconfigurationCollectionRequest entityrelationship_config() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(
                        contextPath.addSegment("entityrelationship_config"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest entityrelationship_config(String solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("entityrelationship_config").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid.toString())), Optional.empty());
    }

}
