package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Appointment;
import microsoft.dynamics.crm.entity.Recurringappointmentmaster;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class AppointmentRequest extends EntityRequest<Appointment> {

    public AppointmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(Appointment.class, contextPath, value, false);
    }

    public PostregardingCollectionRequest appointment_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("appointment_PostRegardings"), Optional.empty());
    }

    public PostregardingRequest appointment_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("appointment_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public PostfollowCollectionRequest appointment_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("appointment_PostFollows"), Optional.empty());
    }

    public PostfollowRequest appointment_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("appointment_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord_appointment() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_appointment"), Optional.empty());
    }

    public QueueitemCollectionRequest appointment_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("Appointment_QueueItem"), Optional.empty());
    }

    public QueueitemRequest appointment_QueueItem(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("Appointment_QueueItem").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest appointment_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Appointment_Annotation"), Optional.empty());
    }

    public AnnotationRequest appointment_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Appointment_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest appointment_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Appointment_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest appointment_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Appointment_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public RecurringappointmentmasterRequest seriesid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("seriesid_recurringappointmentmaster"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit_appointment() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_appointment"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest appointment_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Appointment_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest appointment_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Appointment_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest appointment_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("appointment_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest appointment_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("appointment_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest appointment_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Appointment_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest appointment_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Appointment_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby_appointment() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_appointment"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest appointment_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Appointment_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest appointment_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Appointment_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest appointment_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("appointment_connections1"), Optional.empty());
    }

    public ConnectionRequest appointment_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("appointment_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_appointment() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_appointment"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_appointment(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_appointment").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedby_appointment() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_appointment"), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest appointment_activity_mime_attachment() {
        return new ActivitymimeattachmentCollectionRequest(
                        contextPath.addSegment("appointment_activity_mime_attachment"), Optional.empty());
    }

    public ActivitymimeattachmentRequest appointment_activity_mime_attachment(String activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("appointment_activity_mime_attachment").addKeys(new NameValue(activitymimeattachmentid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest appointment_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Appointment_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest appointment_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Appointment_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest appointment_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("appointment_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest appointment_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("appointment_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest appointment_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("appointment_connections2"), Optional.empty());
    }

    public ConnectionRequest appointment_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("appointment_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ActioncardCollectionRequest appointment_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("appointment_actioncard"), Optional.empty());
    }

    public ActioncardRequest appointment_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("appointment_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public SlaRequest sla_appointment_sla() {
        return new SlaRequest(contextPath.addSegment("sla_appointment_sla"), Optional.empty());
    }

    public ProcesssessionCollectionRequest appointment_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Appointment_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest appointment_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Appointment_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact_appointment() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_appointment"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby_appointment() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_appointment"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle_appointment() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_appointment"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account_appointment() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_appointment"), Optional.empty());
    }

    public ActivitypointerRequest activityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid_appointment() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_appointment"), Optional.empty());
    }

    public SlaRequest slainvokedid_appointment_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_appointment_sla"), Optional.empty());
    }

    public SystemuserRequest createdby_appointment() {
        return new SystemuserRequest(contextPath.addSegment("createdby_appointment"), Optional.empty());
    }

    public TeamRequest owningteam_appointment() {
        return new TeamRequest(contextPath.addSegment("owningteam_appointment"), Optional.empty());
    }

    public SystemuserRequest owninguser_appointment() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_appointment"), Optional.empty());
    }

    public PrincipalRequest ownerid_appointment() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_appointment"), Optional.empty());
    }

    @Action(name = "AddRecurrence")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Recurringappointmentmaster> addRecurrence(Recurringappointmentmaster target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.recurringappointmentmaster", target)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Recurringappointmentmaster>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddRecurrence"), Recurringappointmentmaster.class, _parameters);
    }

}
