package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Appmodule;
import microsoft.dynamics.crm.entity.collection.request.AppconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppmodulecomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ServiceplanCollectionRequest;

@JsonIgnoreType
public class AppmoduleRequest extends EntityRequest<Appmodule> {

    public AppmoduleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Appmodule.class, contextPath, value, false);
    }

    public RoleCollectionRequest appmoduleroles_association() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("appmoduleroles_association"), Optional.empty());
    }

    public RoleRequest appmoduleroles_association(String roleid) {
        return new RoleRequest(contextPath.addSegment("appmoduleroles_association").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    public SystemuserRequest appmodule_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appmodule_modifiedonbehalfby"), Optional.empty());
    }

    public AppconfigCollectionRequest appmodule_appconfig() {
        return new AppconfigCollectionRequest(
                        contextPath.addSegment("appmodule_appconfig"), Optional.empty());
    }

    public AppconfigRequest appmodule_appconfig(String appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("appmodule_appconfig").addKeys(new NameValue(appconfigid.toString())), Optional.empty());
    }

    public SystemuserRequest appmodule_createdby() {
        return new SystemuserRequest(contextPath.addSegment("appmodule_createdby"), Optional.empty());
    }

    public PublisherRequest publisher_appmodule_appmodule() {
        return new PublisherRequest(contextPath.addSegment("publisher_appmodule_appmodule"), Optional.empty());
    }

    public AppmodulecomponentCollectionRequest appmodule_appmodulecomponent() {
        return new AppmodulecomponentCollectionRequest(
                        contextPath.addSegment("appmodule_appmodulecomponent"), Optional.empty());
    }

    public AppmodulecomponentRequest appmodule_appmodulecomponent(String appmodulecomponentid) {
        return new AppmodulecomponentRequest(contextPath.addSegment("appmodule_appmodulecomponent").addKeys(new NameValue(appmodulecomponentid.toString())), Optional.empty());
    }

    public SystemuserRequest appmodule_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("appmodule_modifiedby"), Optional.empty());
    }

    public SystemuserRequest appmodule_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appmodule_createdonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organization_appmodule_appmodule() {
        return new OrganizationRequest(contextPath.addSegment("organization_appmodule_appmodule"), Optional.empty());
    }

    public ServiceplanCollectionRequest serviceplan_appmodule_association() {
        return new ServiceplanCollectionRequest(
                        contextPath.addSegment("serviceplan_appmodule_association"), Optional.empty());
    }

    public ServiceplanRequest serviceplan_appmodule_association(String serviceplanid) {
        return new ServiceplanRequest(contextPath.addSegment("serviceplan_appmodule_association").addKeys(new NameValue(serviceplanid.toString())), Optional.empty());
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Appmodule> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Appmodule>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Appmodule.class, _parameters);
    }

}
