package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Appconfigmaster;
import microsoft.dynamics.crm.entity.collection.request.AppconfiginstanceCollectionRequest;

@JsonIgnoreType
public class AppconfigmasterRequest extends EntityRequest<Appconfigmaster> {

    public AppconfigmasterRequest(ContextPath contextPath, Optional<Object> value) {
        super(Appconfigmaster.class, contextPath, value, false);
    }

    public AppconfiginstanceCollectionRequest appconfigmaster_appconfiginstance() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("appconfigmaster_appconfiginstance"), Optional.empty());
    }

    public AppconfiginstanceRequest appconfigmaster_appconfiginstance(String appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("appconfigmaster_appconfiginstance").addKeys(new NameValue(appconfiginstanceid.toString())), Optional.empty());
    }

    public SystemuserRequest appconfigmaster_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appconfigmaster_createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest appconfigmaster_createdby() {
        return new SystemuserRequest(contextPath.addSegment("appconfigmaster_createdby"), Optional.empty());
    }

    public OrganizationRequest organization_appconfigmaster_appconfigmaster() {
        return new OrganizationRequest(contextPath.addSegment("organization_appconfigmaster_appconfigmaster"), Optional.empty());
    }

    public SystemuserRequest appconfigmaster_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appconfigmaster_modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest appconfigmaster_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("appconfigmaster_modifiedby"), Optional.empty());
    }

}
