package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Account;
import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomeraddressCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;

@JsonIgnoreType
public class AccountRequest extends EntityRequest<Account> {

    public AccountRequest(ContextPath contextPath, Optional<Object> value) {
        super(Account.class, contextPath, value, false);
    }

    public PrincipalobjectattributeaccessCollectionRequest account_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("account_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest account_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("account_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public ActivitypointerCollectionRequest account_ActivityPointers() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("Account_ActivityPointers"), Optional.empty());
    }

    public ActivitypointerRequest account_ActivityPointers(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("Account_ActivityPointers").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest account_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Account_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest account_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Account_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public EmailCollectionRequest account_Email_SendersAccount() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("Account_Email_SendersAccount"), Optional.empty());
    }

    public EmailRequest account_Email_SendersAccount(String activityid) {
        return new EmailRequest(contextPath.addSegment("Account_Email_SendersAccount").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest account_Email_EmailSender() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("Account_Email_EmailSender"), Optional.empty());
    }

    public EmailRequest account_Email_EmailSender(String activityid) {
        return new EmailRequest(contextPath.addSegment("Account_Email_EmailSender").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest account_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Account_Annotation"), Optional.empty());
    }

    public AnnotationRequest account_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Account_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest account_SharepointDocumentLocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("Account_SharepointDocumentLocation"), Optional.empty());
    }

    public SharepointdocumentlocationRequest account_SharepointDocumentLocation(String sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("Account_SharepointDocumentLocation").addKeys(new NameValue(sharepointdocumentlocationid.toString())), Optional.empty());
    }

    public SlaRequest sla_account_sla() {
        return new SlaRequest(contextPath.addSegment("sla_account_sla"), Optional.empty());
    }

    public ConnectionCollectionRequest account_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("account_connections2"), Optional.empty());
    }

    public ConnectionRequest account_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("account_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public PostfollowCollectionRequest account_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("account_PostFollows"), Optional.empty());
    }

    public PostfollowRequest account_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("account_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public PostregardingCollectionRequest account_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("account_PostRegardings"), Optional.empty());
    }

    public PostregardingRequest account_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("account_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest account_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Account_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest account_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Account_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public FaxCollectionRequest account_Faxes() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("Account_Faxes"), Optional.empty());
    }

    public FaxRequest account_Faxes(String activityid) {
        return new FaxRequest(contextPath.addSegment("Account_Faxes").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AccountRequest masterid() {
        return new AccountRequest(contextPath.addSegment("masterid"), Optional.empty());
    }

    public AccountCollectionRequest account_master_account() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("account_master_account"), Optional.empty());
    }

    public AccountRequest account_master_account(String accountid) {
        return new AccountRequest(contextPath.addSegment("account_master_account").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public AsyncoperationCollectionRequest account_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Account_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest account_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Account_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public DuplicaterecordCollectionRequest account_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Account_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest account_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Account_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SystemuserRequest preferredsystemuserid() {
        return new SystemuserRequest(contextPath.addSegment("preferredsystemuserid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest account_RecurringAppointmentMasters() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("Account_RecurringAppointmentMasters"), Optional.empty());
    }

    public RecurringappointmentmasterRequest account_RecurringAppointmentMasters(String activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("Account_RecurringAppointmentMasters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public PhonecallCollectionRequest account_Phonecalls() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("Account_Phonecalls"), Optional.empty());
    }

    public PhonecallRequest account_Phonecalls(String activityid) {
        return new PhonecallRequest(contextPath.addSegment("Account_Phonecalls").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ContactRequest primarycontactid() {
        return new ContactRequest(contextPath.addSegment("primarycontactid"), Optional.empty());
    }

    public SocialactivityCollectionRequest account_SocialActivities() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("Account_SocialActivities"), Optional.empty());
    }

    public SocialactivityRequest account_SocialActivities(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("Account_SocialActivities").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest account_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("Account_MailboxTrackingFolder"), Optional.empty());
    }

    public MailboxtrackingfolderRequest account_MailboxTrackingFolder(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("Account_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest socialActivity_PostAuthorAccount_accounts() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("SocialActivity_PostAuthorAccount_accounts"), Optional.empty());
    }

    public SocialactivityRequest socialActivity_PostAuthorAccount_accounts(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("SocialActivity_PostAuthorAccount_accounts").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public CustomeraddressCollectionRequest account_CustomerAddress() {
        return new CustomeraddressCollectionRequest(
                        contextPath.addSegment("Account_CustomerAddress"), Optional.empty());
    }

    public CustomeraddressRequest account_CustomerAddress(String customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("Account_CustomerAddress").addKeys(new NameValue(customeraddressid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_account() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_account"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_account(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_account").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public TaskCollectionRequest account_Tasks() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("Account_Tasks"), Optional.empty());
    }

    public TaskRequest account_Tasks(String activityid) {
        return new TaskRequest(contextPath.addSegment("Account_Tasks").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SlaRequest slainvokedid_account_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_account_sla"), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest account_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Account_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest account_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Account_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest socialActivity_PostAuthor_accounts() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("SocialActivity_PostAuthor_accounts"), Optional.empty());
    }

    public SocialactivityRequest socialActivity_PostAuthor_accounts(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("SocialActivity_PostAuthor_accounts").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ContactCollectionRequest contact_customer_accounts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contact_customer_accounts"), Optional.empty());
    }

    public ContactRequest contact_customer_accounts(String contactid) {
        return new ContactRequest(contextPath.addSegment("contact_customer_accounts").addKeys(new NameValue(contactid.toString())), Optional.empty());
    }

    public AppointmentCollectionRequest account_Appointments() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("Account_Appointments"), Optional.empty());
    }

    public AppointmentRequest account_Appointments(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("Account_Appointments").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest account_Emails() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("Account_Emails"), Optional.empty());
    }

    public EmailRequest account_Emails(String activityid) {
        return new EmailRequest(contextPath.addSegment("Account_Emails").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AccountRequest parentaccountid() {
        return new AccountRequest(contextPath.addSegment("parentaccountid"), Optional.empty());
    }

    public AccountCollectionRequest account_parent_account() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("account_parent_account"), Optional.empty());
    }

    public AccountRequest account_parent_account(String accountid) {
        return new AccountRequest(contextPath.addSegment("account_parent_account").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public SocialprofileCollectionRequest socialprofile_customer_accounts() {
        return new SocialprofileCollectionRequest(
                        contextPath.addSegment("Socialprofile_customer_accounts"), Optional.empty());
    }

    public SocialprofileRequest socialprofile_customer_accounts(String socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("Socialprofile_customer_accounts").addKeys(new NameValue(socialprofileid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest account_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Account_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest account_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Account_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest account_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("account_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest account_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("account_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest account_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("account_connections1"), Optional.empty());
    }

    public ConnectionRequest account_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("account_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public ActioncardCollectionRequest account_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("account_actioncard"), Optional.empty());
    }

    public ActioncardRequest account_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("account_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public LetterCollectionRequest account_Letters() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("Account_Letters"), Optional.empty());
    }

    public LetterRequest account_Letters(String activityid) {
        return new LetterRequest(contextPath.addSegment("Account_Letters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

}
