package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PlugintypeRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_organizationid_value", 
    "_createdby_value", 
    "_modifiedby_value", 
    "crashcount", 
    "executecount", 
    "terminatememorycontributionpercent", 
    "terminateothercontributionpercent", 
    "_modifiedonbehalfby_value", 
    "terminatecpucontributionpercent", 
    "failurepercent", 
    "createdon", 
    "averageexecutetimeinmilliseconds", 
    "_plugintypeid_value", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "plugintypestatisticid", 
    "terminatehandlescontributionpercent", 
    "crashpercent", 
    "failurecount", 
    "crashcontributionpercent"})
@JsonInclude(Include.NON_NULL)
public class Plugintypestatistic extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.plugintypestatistic";
    }

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("crashcount")
    protected Integer crashcount;

    @JsonProperty("executecount")
    protected Integer executecount;

    @JsonProperty("terminatememorycontributionpercent")
    protected Integer terminatememorycontributionpercent;

    @JsonProperty("terminateothercontributionpercent")
    protected Integer terminateothercontributionpercent;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("terminatecpucontributionpercent")
    protected Integer terminatecpucontributionpercent;

    @JsonProperty("failurepercent")
    protected Integer failurepercent;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("averageexecutetimeinmilliseconds")
    protected Integer averageexecutetimeinmilliseconds;

    @JsonProperty("_plugintypeid_value")
    protected String _plugintypeid_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("plugintypestatisticid")
    protected String plugintypestatisticid;

    @JsonProperty("terminatehandlescontributionpercent")
    protected Integer terminatehandlescontributionpercent;

    @JsonProperty("crashpercent")
    protected Integer crashpercent;

    @JsonProperty("failurecount")
    protected Integer failurecount;

    @JsonProperty("crashcontributionpercent")
    protected Integer crashcontributionpercent;

    protected Plugintypestatistic() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlugintypestatistic() {
        return new Builder();
    }

    public static final class Builder {
        private String _organizationid_value;
        private String _createdby_value;
        private String _modifiedby_value;
        private Integer crashcount;
        private Integer executecount;
        private Integer terminatememorycontributionpercent;
        private Integer terminateothercontributionpercent;
        private String _modifiedonbehalfby_value;
        private Integer terminatecpucontributionpercent;
        private Integer failurepercent;
        private OffsetDateTime createdon;
        private Integer averageexecutetimeinmilliseconds;
        private String _plugintypeid_value;
        private String _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private String plugintypestatisticid;
        private Integer terminatehandlescontributionpercent;
        private Integer crashpercent;
        private Integer failurecount;
        private Integer crashcontributionpercent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder crashcount(Integer crashcount) {
            this.crashcount = crashcount;
            this.changedFields = changedFields.add("crashcount");
            return this;
        }

        public Builder executecount(Integer executecount) {
            this.executecount = executecount;
            this.changedFields = changedFields.add("executecount");
            return this;
        }

        public Builder terminatememorycontributionpercent(Integer terminatememorycontributionpercent) {
            this.terminatememorycontributionpercent = terminatememorycontributionpercent;
            this.changedFields = changedFields.add("terminatememorycontributionpercent");
            return this;
        }

        public Builder terminateothercontributionpercent(Integer terminateothercontributionpercent) {
            this.terminateothercontributionpercent = terminateothercontributionpercent;
            this.changedFields = changedFields.add("terminateothercontributionpercent");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder terminatecpucontributionpercent(Integer terminatecpucontributionpercent) {
            this.terminatecpucontributionpercent = terminatecpucontributionpercent;
            this.changedFields = changedFields.add("terminatecpucontributionpercent");
            return this;
        }

        public Builder failurepercent(Integer failurepercent) {
            this.failurepercent = failurepercent;
            this.changedFields = changedFields.add("failurepercent");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder averageexecutetimeinmilliseconds(Integer averageexecutetimeinmilliseconds) {
            this.averageexecutetimeinmilliseconds = averageexecutetimeinmilliseconds;
            this.changedFields = changedFields.add("averageexecutetimeinmilliseconds");
            return this;
        }

        public Builder _plugintypeid_value(String _plugintypeid_value) {
            this._plugintypeid_value = _plugintypeid_value;
            this.changedFields = changedFields.add("_plugintypeid_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder plugintypestatisticid(String plugintypestatisticid) {
            this.plugintypestatisticid = plugintypestatisticid;
            this.changedFields = changedFields.add("plugintypestatisticid");
            return this;
        }

        public Builder terminatehandlescontributionpercent(Integer terminatehandlescontributionpercent) {
            this.terminatehandlescontributionpercent = terminatehandlescontributionpercent;
            this.changedFields = changedFields.add("terminatehandlescontributionpercent");
            return this;
        }

        public Builder crashpercent(Integer crashpercent) {
            this.crashpercent = crashpercent;
            this.changedFields = changedFields.add("crashpercent");
            return this;
        }

        public Builder failurecount(Integer failurecount) {
            this.failurecount = failurecount;
            this.changedFields = changedFields.add("failurecount");
            return this;
        }

        public Builder crashcontributionpercent(Integer crashcontributionpercent) {
            this.crashcontributionpercent = crashcontributionpercent;
            this.changedFields = changedFields.add("crashcontributionpercent");
            return this;
        }

        public Plugintypestatistic build() {
            Plugintypestatistic _x = new Plugintypestatistic();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.plugintypestatistic";
            _x._organizationid_value = _organizationid_value;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.crashcount = crashcount;
            _x.executecount = executecount;
            _x.terminatememorycontributionpercent = terminatememorycontributionpercent;
            _x.terminateothercontributionpercent = terminateothercontributionpercent;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.terminatecpucontributionpercent = terminatecpucontributionpercent;
            _x.failurepercent = failurepercent;
            _x.createdon = createdon;
            _x.averageexecutetimeinmilliseconds = averageexecutetimeinmilliseconds;
            _x._plugintypeid_value = _plugintypeid_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.plugintypestatisticid = plugintypestatisticid;
            _x.terminatehandlescontributionpercent = terminatehandlescontributionpercent;
            _x.crashpercent = crashpercent;
            _x.failurecount = failurecount;
            _x.crashcontributionpercent = crashcontributionpercent;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && plugintypestatisticid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(plugintypestatisticid.toString()));
        }
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Plugintypestatistic with_organizationid_value(String _organizationid_value) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Plugintypestatistic with_createdby_value(String _createdby_value) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Plugintypestatistic with_modifiedby_value(String _modifiedby_value) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="crashcount")
    @JsonIgnore
    public Optional<Integer> getCrashcount() {
        return Optional.ofNullable(crashcount);
    }

    public Plugintypestatistic withCrashcount(Integer crashcount) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("crashcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.crashcount = crashcount;
        return _x;
    }

    @Property(name="executecount")
    @JsonIgnore
    public Optional<Integer> getExecutecount() {
        return Optional.ofNullable(executecount);
    }

    public Plugintypestatistic withExecutecount(Integer executecount) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("executecount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.executecount = executecount;
        return _x;
    }

    @Property(name="terminatememorycontributionpercent")
    @JsonIgnore
    public Optional<Integer> getTerminatememorycontributionpercent() {
        return Optional.ofNullable(terminatememorycontributionpercent);
    }

    public Plugintypestatistic withTerminatememorycontributionpercent(Integer terminatememorycontributionpercent) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("terminatememorycontributionpercent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.terminatememorycontributionpercent = terminatememorycontributionpercent;
        return _x;
    }

    @Property(name="terminateothercontributionpercent")
    @JsonIgnore
    public Optional<Integer> getTerminateothercontributionpercent() {
        return Optional.ofNullable(terminateothercontributionpercent);
    }

    public Plugintypestatistic withTerminateothercontributionpercent(Integer terminateothercontributionpercent) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("terminateothercontributionpercent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.terminateothercontributionpercent = terminateothercontributionpercent;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Plugintypestatistic with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="terminatecpucontributionpercent")
    @JsonIgnore
    public Optional<Integer> getTerminatecpucontributionpercent() {
        return Optional.ofNullable(terminatecpucontributionpercent);
    }

    public Plugintypestatistic withTerminatecpucontributionpercent(Integer terminatecpucontributionpercent) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("terminatecpucontributionpercent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.terminatecpucontributionpercent = terminatecpucontributionpercent;
        return _x;
    }

    @Property(name="failurepercent")
    @JsonIgnore
    public Optional<Integer> getFailurepercent() {
        return Optional.ofNullable(failurepercent);
    }

    public Plugintypestatistic withFailurepercent(Integer failurepercent) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("failurepercent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.failurepercent = failurepercent;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Plugintypestatistic withCreatedon(OffsetDateTime createdon) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="averageexecutetimeinmilliseconds")
    @JsonIgnore
    public Optional<Integer> getAverageexecutetimeinmilliseconds() {
        return Optional.ofNullable(averageexecutetimeinmilliseconds);
    }

    public Plugintypestatistic withAverageexecutetimeinmilliseconds(Integer averageexecutetimeinmilliseconds) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("averageexecutetimeinmilliseconds");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.averageexecutetimeinmilliseconds = averageexecutetimeinmilliseconds;
        return _x;
    }

    @Property(name="_plugintypeid_value")
    @JsonIgnore
    public Optional<String> get_plugintypeid_value() {
        return Optional.ofNullable(_plugintypeid_value);
    }

    public Plugintypestatistic with_plugintypeid_value(String _plugintypeid_value) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("_plugintypeid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x._plugintypeid_value = _plugintypeid_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Plugintypestatistic with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Plugintypestatistic withModifiedon(OffsetDateTime modifiedon) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="plugintypestatisticid")
    @JsonIgnore
    public Optional<String> getPlugintypestatisticid() {
        return Optional.ofNullable(plugintypestatisticid);
    }

    public Plugintypestatistic withPlugintypestatisticid(String plugintypestatisticid) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("plugintypestatisticid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.plugintypestatisticid = plugintypestatisticid;
        return _x;
    }

    @Property(name="terminatehandlescontributionpercent")
    @JsonIgnore
    public Optional<Integer> getTerminatehandlescontributionpercent() {
        return Optional.ofNullable(terminatehandlescontributionpercent);
    }

    public Plugintypestatistic withTerminatehandlescontributionpercent(Integer terminatehandlescontributionpercent) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("terminatehandlescontributionpercent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.terminatehandlescontributionpercent = terminatehandlescontributionpercent;
        return _x;
    }

    @Property(name="crashpercent")
    @JsonIgnore
    public Optional<Integer> getCrashpercent() {
        return Optional.ofNullable(crashpercent);
    }

    public Plugintypestatistic withCrashpercent(Integer crashpercent) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("crashpercent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.crashpercent = crashpercent;
        return _x;
    }

    @Property(name="failurecount")
    @JsonIgnore
    public Optional<Integer> getFailurecount() {
        return Optional.ofNullable(failurecount);
    }

    public Plugintypestatistic withFailurecount(Integer failurecount) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("failurecount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.failurecount = failurecount;
        return _x;
    }

    @Property(name="crashcontributionpercent")
    @JsonIgnore
    public Optional<Integer> getCrashcontributionpercent() {
        return Optional.ofNullable(crashcontributionpercent);
    }

    public Plugintypestatistic withCrashcontributionpercent(Integer crashcontributionpercent) {
        Plugintypestatistic _x = _copy();
        _x.changedFields = changedFields.add("crashcontributionpercent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintypestatistic");
        _x.crashcontributionpercent = crashcontributionpercent;
        return _x;
    }

    public Plugintypestatistic withUnmappedField(String name, String value) {
        Plugintypestatistic _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="plugintypeid")
    @JsonIgnore
    public PlugintypeRequest getPlugintypeid() {
        return new PlugintypeRequest(contextPath.addSegment("plugintypeid"), RequestHelper.getValue(unmappedFields, "plugintypeid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Plugintypestatistic patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Plugintypestatistic _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Plugintypestatistic put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Plugintypestatistic _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Plugintypestatistic _copy() {
        Plugintypestatistic _x = new Plugintypestatistic();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._organizationid_value = _organizationid_value;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.crashcount = crashcount;
        _x.executecount = executecount;
        _x.terminatememorycontributionpercent = terminatememorycontributionpercent;
        _x.terminateothercontributionpercent = terminateothercontributionpercent;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.terminatecpucontributionpercent = terminatecpucontributionpercent;
        _x.failurepercent = failurepercent;
        _x.createdon = createdon;
        _x.averageexecutetimeinmilliseconds = averageexecutetimeinmilliseconds;
        _x._plugintypeid_value = _plugintypeid_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.plugintypestatisticid = plugintypestatisticid;
        _x.terminatehandlescontributionpercent = terminatehandlescontributionpercent;
        _x.crashpercent = crashpercent;
        _x.failurecount = failurecount;
        _x.crashcontributionpercent = crashcontributionpercent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Plugintypestatistic[");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("crashcount=");
        b.append(this.crashcount);
        b.append(", ");
        b.append("executecount=");
        b.append(this.executecount);
        b.append(", ");
        b.append("terminatememorycontributionpercent=");
        b.append(this.terminatememorycontributionpercent);
        b.append(", ");
        b.append("terminateothercontributionpercent=");
        b.append(this.terminateothercontributionpercent);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("terminatecpucontributionpercent=");
        b.append(this.terminatecpucontributionpercent);
        b.append(", ");
        b.append("failurepercent=");
        b.append(this.failurepercent);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("averageexecutetimeinmilliseconds=");
        b.append(this.averageexecutetimeinmilliseconds);
        b.append(", ");
        b.append("_plugintypeid_value=");
        b.append(this._plugintypeid_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("plugintypestatisticid=");
        b.append(this.plugintypestatisticid);
        b.append(", ");
        b.append("terminatehandlescontributionpercent=");
        b.append(this.terminatehandlescontributionpercent);
        b.append(", ");
        b.append("crashpercent=");
        b.append(this.crashpercent);
        b.append(", ");
        b.append("failurecount=");
        b.append(this.failurecount);
        b.append(", ");
        b.append("crashcontributionpercent=");
        b.append(this.crashcontributionpercent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
