package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.CancelTrainingResponse;
import microsoft.dynamics.crm.complex.PublishAIConfigurationResponse;
import microsoft.dynamics.crm.complex.QuickTestResponse;
import microsoft.dynamics.crm.complex.ScheduleTrainingResponse;
import microsoft.dynamics.crm.complex.TrainResponse;
import microsoft.dynamics.crm.complex.UnpublishAIConfigurationResponse;
import microsoft.dynamics.crm.complex.UnscheduleTrainingResponse;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aifptrainingdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodlabelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "solutionid", 
    "msdyn_customconfiguration", 
    "msdyn_resourceinfo", 
    "_ownerid_value", 
    "msdyn_modeldata", 
    "_owningteam_value", 
    "_createdonbehalfby_value", 
    "createdon", 
    "overriddencreatedon", 
    "msdyn_lasttrainorrundate", 
    "msdyn_databinding", 
    "msdyn_lasterrors", 
    "utcconversiontimezonecode", 
    "_createdby_value", 
    "msdyn_modelglobalexplainability", 
    "msdyn_model_name", 
    "msdyn_majoriterationnumber", 
    "_owningbusinessunit_value", 
    "msdyn_modelprovisioningstatus", 
    "msdyn_model", 
    "msdyn_runconfiguration", 
    "_msdyn_createdfromconfigurationid_value", 
    "_msdyn_trainedmodelaiconfigurationpareid_value", 
    "msdyn_aiconfigurationid", 
    "overwritetime", 
    "importsequencenumber", 
    "_modifiedonbehalfby_value", 
    "statuscode", 
    "msdyn_type", 
    "_msdyn_aimodelid_value", 
    "iscustomizable", 
    "versionnumber", 
    "componentstate", 
    "modifiedon", 
    "msdyn_schedulingoptions", 
    "msdyn_aiconfigurationidunique", 
    "msdyn_modelprovisioningmetadata", 
    "ismanaged", 
    "timezoneruleversionnumber", 
    "_modifiedby_value", 
    "statecode", 
    "msdyn_modelrundataspecification", 
    "_owninguser_value", 
    "msdyn_templateversion", 
    "introducedversion", 
    "msdyn_modelperformance", 
    "msdyn_name", 
    "msdyn_minoriterationnumber"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aiconfiguration extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aiconfiguration";
    }

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("msdyn_customconfiguration")
    protected String msdyn_customconfiguration;

    @JsonProperty("msdyn_resourceinfo")
    protected String msdyn_resourceinfo;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("msdyn_modeldata")
    protected String msdyn_modeldata;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_lasttrainorrundate")
    protected OffsetDateTime msdyn_lasttrainorrundate;

    @JsonProperty("msdyn_databinding")
    protected String msdyn_databinding;

    @JsonProperty("msdyn_lasterrors")
    protected String msdyn_lasterrors;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("msdyn_modelglobalexplainability")
    protected String msdyn_modelglobalexplainability;

    @JsonProperty("msdyn_model_name")
    protected String msdyn_model_name;

    @JsonProperty("msdyn_majoriterationnumber")
    protected Integer msdyn_majoriterationnumber;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("msdyn_modelprovisioningstatus")
    protected String msdyn_modelprovisioningstatus;

    @JsonProperty("msdyn_model")
    protected byte[] msdyn_model;

    @JsonProperty("msdyn_runconfiguration")
    protected String msdyn_runconfiguration;

    @JsonProperty("_msdyn_createdfromconfigurationid_value")
    protected String _msdyn_createdfromconfigurationid_value;

    @JsonProperty("_msdyn_trainedmodelaiconfigurationpareid_value")
    protected String _msdyn_trainedmodelaiconfigurationpareid_value;

    @JsonProperty("msdyn_aiconfigurationid")
    protected String msdyn_aiconfigurationid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("msdyn_type")
    protected Integer msdyn_type;

    @JsonProperty("_msdyn_aimodelid_value")
    protected String _msdyn_aimodelid_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("msdyn_schedulingoptions")
    protected String msdyn_schedulingoptions;

    @JsonProperty("msdyn_aiconfigurationidunique")
    protected String msdyn_aiconfigurationidunique;

    @JsonProperty("msdyn_modelprovisioningmetadata")
    protected String msdyn_modelprovisioningmetadata;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("msdyn_modelrundataspecification")
    protected String msdyn_modelrundataspecification;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("msdyn_templateversion")
    protected Integer msdyn_templateversion;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("msdyn_modelperformance")
    protected String msdyn_modelperformance;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_minoriterationnumber")
    protected Integer msdyn_minoriterationnumber;

    protected Msdyn_aiconfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aiconfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String solutionid;
        private String msdyn_customconfiguration;
        private String msdyn_resourceinfo;
        private String _ownerid_value;
        private String msdyn_modeldata;
        private String _owningteam_value;
        private String _createdonbehalfby_value;
        private OffsetDateTime createdon;
        private OffsetDateTime overriddencreatedon;
        private OffsetDateTime msdyn_lasttrainorrundate;
        private String msdyn_databinding;
        private String msdyn_lasterrors;
        private Integer utcconversiontimezonecode;
        private String _createdby_value;
        private String msdyn_modelglobalexplainability;
        private String msdyn_model_name;
        private Integer msdyn_majoriterationnumber;
        private String _owningbusinessunit_value;
        private String msdyn_modelprovisioningstatus;
        private byte[] msdyn_model;
        private String msdyn_runconfiguration;
        private String _msdyn_createdfromconfigurationid_value;
        private String _msdyn_trainedmodelaiconfigurationpareid_value;
        private String msdyn_aiconfigurationid;
        private OffsetDateTime overwritetime;
        private Integer importsequencenumber;
        private String _modifiedonbehalfby_value;
        private Integer statuscode;
        private Integer msdyn_type;
        private String _msdyn_aimodelid_value;
        private BooleanManagedProperty iscustomizable;
        private Long versionnumber;
        private Integer componentstate;
        private OffsetDateTime modifiedon;
        private String msdyn_schedulingoptions;
        private String msdyn_aiconfigurationidunique;
        private String msdyn_modelprovisioningmetadata;
        private Boolean ismanaged;
        private Integer timezoneruleversionnumber;
        private String _modifiedby_value;
        private Integer statecode;
        private String msdyn_modelrundataspecification;
        private String _owninguser_value;
        private Integer msdyn_templateversion;
        private String introducedversion;
        private String msdyn_modelperformance;
        private String msdyn_name;
        private Integer msdyn_minoriterationnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder msdyn_customconfiguration(String msdyn_customconfiguration) {
            this.msdyn_customconfiguration = msdyn_customconfiguration;
            this.changedFields = changedFields.add("msdyn_customconfiguration");
            return this;
        }

        public Builder msdyn_resourceinfo(String msdyn_resourceinfo) {
            this.msdyn_resourceinfo = msdyn_resourceinfo;
            this.changedFields = changedFields.add("msdyn_resourceinfo");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder msdyn_modeldata(String msdyn_modeldata) {
            this.msdyn_modeldata = msdyn_modeldata;
            this.changedFields = changedFields.add("msdyn_modeldata");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_lasttrainorrundate(OffsetDateTime msdyn_lasttrainorrundate) {
            this.msdyn_lasttrainorrundate = msdyn_lasttrainorrundate;
            this.changedFields = changedFields.add("msdyn_lasttrainorrundate");
            return this;
        }

        public Builder msdyn_databinding(String msdyn_databinding) {
            this.msdyn_databinding = msdyn_databinding;
            this.changedFields = changedFields.add("msdyn_databinding");
            return this;
        }

        public Builder msdyn_lasterrors(String msdyn_lasterrors) {
            this.msdyn_lasterrors = msdyn_lasterrors;
            this.changedFields = changedFields.add("msdyn_lasterrors");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder msdyn_modelglobalexplainability(String msdyn_modelglobalexplainability) {
            this.msdyn_modelglobalexplainability = msdyn_modelglobalexplainability;
            this.changedFields = changedFields.add("msdyn_modelglobalexplainability");
            return this;
        }

        public Builder msdyn_model_name(String msdyn_model_name) {
            this.msdyn_model_name = msdyn_model_name;
            this.changedFields = changedFields.add("msdyn_model_name");
            return this;
        }

        public Builder msdyn_majoriterationnumber(Integer msdyn_majoriterationnumber) {
            this.msdyn_majoriterationnumber = msdyn_majoriterationnumber;
            this.changedFields = changedFields.add("msdyn_majoriterationnumber");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder msdyn_modelprovisioningstatus(String msdyn_modelprovisioningstatus) {
            this.msdyn_modelprovisioningstatus = msdyn_modelprovisioningstatus;
            this.changedFields = changedFields.add("msdyn_modelprovisioningstatus");
            return this;
        }

        public Builder msdyn_model(byte[] msdyn_model) {
            this.msdyn_model = msdyn_model;
            this.changedFields = changedFields.add("msdyn_model");
            return this;
        }

        public Builder msdyn_runconfiguration(String msdyn_runconfiguration) {
            this.msdyn_runconfiguration = msdyn_runconfiguration;
            this.changedFields = changedFields.add("msdyn_runconfiguration");
            return this;
        }

        public Builder _msdyn_createdfromconfigurationid_value(String _msdyn_createdfromconfigurationid_value) {
            this._msdyn_createdfromconfigurationid_value = _msdyn_createdfromconfigurationid_value;
            this.changedFields = changedFields.add("_msdyn_createdfromconfigurationid_value");
            return this;
        }

        public Builder _msdyn_trainedmodelaiconfigurationpareid_value(String _msdyn_trainedmodelaiconfigurationpareid_value) {
            this._msdyn_trainedmodelaiconfigurationpareid_value = _msdyn_trainedmodelaiconfigurationpareid_value;
            this.changedFields = changedFields.add("_msdyn_trainedmodelaiconfigurationpareid_value");
            return this;
        }

        public Builder msdyn_aiconfigurationid(String msdyn_aiconfigurationid) {
            this.msdyn_aiconfigurationid = msdyn_aiconfigurationid;
            this.changedFields = changedFields.add("msdyn_aiconfigurationid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder msdyn_type(Integer msdyn_type) {
            this.msdyn_type = msdyn_type;
            this.changedFields = changedFields.add("msdyn_type");
            return this;
        }

        public Builder _msdyn_aimodelid_value(String _msdyn_aimodelid_value) {
            this._msdyn_aimodelid_value = _msdyn_aimodelid_value;
            this.changedFields = changedFields.add("_msdyn_aimodelid_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder msdyn_schedulingoptions(String msdyn_schedulingoptions) {
            this.msdyn_schedulingoptions = msdyn_schedulingoptions;
            this.changedFields = changedFields.add("msdyn_schedulingoptions");
            return this;
        }

        public Builder msdyn_aiconfigurationidunique(String msdyn_aiconfigurationidunique) {
            this.msdyn_aiconfigurationidunique = msdyn_aiconfigurationidunique;
            this.changedFields = changedFields.add("msdyn_aiconfigurationidunique");
            return this;
        }

        public Builder msdyn_modelprovisioningmetadata(String msdyn_modelprovisioningmetadata) {
            this.msdyn_modelprovisioningmetadata = msdyn_modelprovisioningmetadata;
            this.changedFields = changedFields.add("msdyn_modelprovisioningmetadata");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder msdyn_modelrundataspecification(String msdyn_modelrundataspecification) {
            this.msdyn_modelrundataspecification = msdyn_modelrundataspecification;
            this.changedFields = changedFields.add("msdyn_modelrundataspecification");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder msdyn_templateversion(Integer msdyn_templateversion) {
            this.msdyn_templateversion = msdyn_templateversion;
            this.changedFields = changedFields.add("msdyn_templateversion");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder msdyn_modelperformance(String msdyn_modelperformance) {
            this.msdyn_modelperformance = msdyn_modelperformance;
            this.changedFields = changedFields.add("msdyn_modelperformance");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_minoriterationnumber(Integer msdyn_minoriterationnumber) {
            this.msdyn_minoriterationnumber = msdyn_minoriterationnumber;
            this.changedFields = changedFields.add("msdyn_minoriterationnumber");
            return this;
        }

        public Msdyn_aiconfiguration build() {
            Msdyn_aiconfiguration _x = new Msdyn_aiconfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aiconfiguration";
            _x.solutionid = solutionid;
            _x.msdyn_customconfiguration = msdyn_customconfiguration;
            _x.msdyn_resourceinfo = msdyn_resourceinfo;
            _x._ownerid_value = _ownerid_value;
            _x.msdyn_modeldata = msdyn_modeldata;
            _x._owningteam_value = _owningteam_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.createdon = createdon;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_lasttrainorrundate = msdyn_lasttrainorrundate;
            _x.msdyn_databinding = msdyn_databinding;
            _x.msdyn_lasterrors = msdyn_lasterrors;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._createdby_value = _createdby_value;
            _x.msdyn_modelglobalexplainability = msdyn_modelglobalexplainability;
            _x.msdyn_model_name = msdyn_model_name;
            _x.msdyn_majoriterationnumber = msdyn_majoriterationnumber;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.msdyn_modelprovisioningstatus = msdyn_modelprovisioningstatus;
            _x.msdyn_model = msdyn_model;
            _x.msdyn_runconfiguration = msdyn_runconfiguration;
            _x._msdyn_createdfromconfigurationid_value = _msdyn_createdfromconfigurationid_value;
            _x._msdyn_trainedmodelaiconfigurationpareid_value = _msdyn_trainedmodelaiconfigurationpareid_value;
            _x.msdyn_aiconfigurationid = msdyn_aiconfigurationid;
            _x.overwritetime = overwritetime;
            _x.importsequencenumber = importsequencenumber;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.statuscode = statuscode;
            _x.msdyn_type = msdyn_type;
            _x._msdyn_aimodelid_value = _msdyn_aimodelid_value;
            _x.iscustomizable = iscustomizable;
            _x.versionnumber = versionnumber;
            _x.componentstate = componentstate;
            _x.modifiedon = modifiedon;
            _x.msdyn_schedulingoptions = msdyn_schedulingoptions;
            _x.msdyn_aiconfigurationidunique = msdyn_aiconfigurationidunique;
            _x.msdyn_modelprovisioningmetadata = msdyn_modelprovisioningmetadata;
            _x.ismanaged = ismanaged;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._modifiedby_value = _modifiedby_value;
            _x.statecode = statecode;
            _x.msdyn_modelrundataspecification = msdyn_modelrundataspecification;
            _x._owninguser_value = _owninguser_value;
            _x.msdyn_templateversion = msdyn_templateversion;
            _x.introducedversion = introducedversion;
            _x.msdyn_modelperformance = msdyn_modelperformance;
            _x.msdyn_name = msdyn_name;
            _x.msdyn_minoriterationnumber = msdyn_minoriterationnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aiconfigurationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aiconfigurationid.toString()));
        }
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Msdyn_aiconfiguration withSolutionid(String solutionid) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="msdyn_customconfiguration")
    @JsonIgnore
    public Optional<String> getMsdyn_customconfiguration() {
        return Optional.ofNullable(msdyn_customconfiguration);
    }

    public Msdyn_aiconfiguration withMsdyn_customconfiguration(String msdyn_customconfiguration) {
        Checks.checkIsAscii(msdyn_customconfiguration);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_customconfiguration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_customconfiguration = msdyn_customconfiguration;
        return _x;
    }

    @Property(name="msdyn_resourceinfo")
    @JsonIgnore
    public Optional<String> getMsdyn_resourceinfo() {
        return Optional.ofNullable(msdyn_resourceinfo);
    }

    public Msdyn_aiconfiguration withMsdyn_resourceinfo(String msdyn_resourceinfo) {
        Checks.checkIsAscii(msdyn_resourceinfo);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_resourceinfo");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_resourceinfo = msdyn_resourceinfo;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aiconfiguration with_ownerid_value(String _ownerid_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="msdyn_modeldata")
    @JsonIgnore
    public Optional<String> getMsdyn_modeldata() {
        return Optional.ofNullable(msdyn_modeldata);
    }

    public Msdyn_aiconfiguration withMsdyn_modeldata(String msdyn_modeldata) {
        Checks.checkIsAscii(msdyn_modeldata);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_modeldata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_modeldata = msdyn_modeldata;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aiconfiguration with_owningteam_value(String _owningteam_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aiconfiguration with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aiconfiguration withCreatedon(OffsetDateTime createdon) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aiconfiguration withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_lasttrainorrundate")
    @JsonIgnore
    public Optional<OffsetDateTime> getMsdyn_lasttrainorrundate() {
        return Optional.ofNullable(msdyn_lasttrainorrundate);
    }

    public Msdyn_aiconfiguration withMsdyn_lasttrainorrundate(OffsetDateTime msdyn_lasttrainorrundate) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_lasttrainorrundate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_lasttrainorrundate = msdyn_lasttrainorrundate;
        return _x;
    }

    @Property(name="msdyn_databinding")
    @JsonIgnore
    public Optional<String> getMsdyn_databinding() {
        return Optional.ofNullable(msdyn_databinding);
    }

    public Msdyn_aiconfiguration withMsdyn_databinding(String msdyn_databinding) {
        Checks.checkIsAscii(msdyn_databinding);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_databinding");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_databinding = msdyn_databinding;
        return _x;
    }

    @Property(name="msdyn_lasterrors")
    @JsonIgnore
    public Optional<String> getMsdyn_lasterrors() {
        return Optional.ofNullable(msdyn_lasterrors);
    }

    public Msdyn_aiconfiguration withMsdyn_lasterrors(String msdyn_lasterrors) {
        Checks.checkIsAscii(msdyn_lasterrors);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_lasterrors");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_lasterrors = msdyn_lasterrors;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aiconfiguration withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aiconfiguration with_createdby_value(String _createdby_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="msdyn_modelglobalexplainability")
    @JsonIgnore
    public Optional<String> getMsdyn_modelglobalexplainability() {
        return Optional.ofNullable(msdyn_modelglobalexplainability);
    }

    public Msdyn_aiconfiguration withMsdyn_modelglobalexplainability(String msdyn_modelglobalexplainability) {
        Checks.checkIsAscii(msdyn_modelglobalexplainability);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_modelglobalexplainability");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_modelglobalexplainability = msdyn_modelglobalexplainability;
        return _x;
    }

    @Property(name="msdyn_model_name")
    @JsonIgnore
    public Optional<String> getMsdyn_model_name() {
        return Optional.ofNullable(msdyn_model_name);
    }

    public Msdyn_aiconfiguration withMsdyn_model_name(String msdyn_model_name) {
        Checks.checkIsAscii(msdyn_model_name);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_model_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_model_name = msdyn_model_name;
        return _x;
    }

    @Property(name="msdyn_majoriterationnumber")
    @JsonIgnore
    public Optional<Integer> getMsdyn_majoriterationnumber() {
        return Optional.ofNullable(msdyn_majoriterationnumber);
    }

    public Msdyn_aiconfiguration withMsdyn_majoriterationnumber(Integer msdyn_majoriterationnumber) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_majoriterationnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_majoriterationnumber = msdyn_majoriterationnumber;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aiconfiguration with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="msdyn_modelprovisioningstatus")
    @JsonIgnore
    public Optional<String> getMsdyn_modelprovisioningstatus() {
        return Optional.ofNullable(msdyn_modelprovisioningstatus);
    }

    public Msdyn_aiconfiguration withMsdyn_modelprovisioningstatus(String msdyn_modelprovisioningstatus) {
        Checks.checkIsAscii(msdyn_modelprovisioningstatus);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_modelprovisioningstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_modelprovisioningstatus = msdyn_modelprovisioningstatus;
        return _x;
    }

    @Property(name="msdyn_model")
    @JsonIgnore
    public Optional<byte[]> getMsdyn_model() {
        return Optional.ofNullable(msdyn_model);
    }

    public Msdyn_aiconfiguration withMsdyn_model(byte[] msdyn_model) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_model");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_model = msdyn_model;
        return _x;
    }

    @Property(name="msdyn_runconfiguration")
    @JsonIgnore
    public Optional<String> getMsdyn_runconfiguration() {
        return Optional.ofNullable(msdyn_runconfiguration);
    }

    public Msdyn_aiconfiguration withMsdyn_runconfiguration(String msdyn_runconfiguration) {
        Checks.checkIsAscii(msdyn_runconfiguration);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_runconfiguration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_runconfiguration = msdyn_runconfiguration;
        return _x;
    }

    @Property(name="_msdyn_createdfromconfigurationid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_createdfromconfigurationid_value() {
        return Optional.ofNullable(_msdyn_createdfromconfigurationid_value);
    }

    public Msdyn_aiconfiguration with_msdyn_createdfromconfigurationid_value(String _msdyn_createdfromconfigurationid_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_createdfromconfigurationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._msdyn_createdfromconfigurationid_value = _msdyn_createdfromconfigurationid_value;
        return _x;
    }

    @Property(name="_msdyn_trainedmodelaiconfigurationpareid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_trainedmodelaiconfigurationpareid_value() {
        return Optional.ofNullable(_msdyn_trainedmodelaiconfigurationpareid_value);
    }

    public Msdyn_aiconfiguration with_msdyn_trainedmodelaiconfigurationpareid_value(String _msdyn_trainedmodelaiconfigurationpareid_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_trainedmodelaiconfigurationpareid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._msdyn_trainedmodelaiconfigurationpareid_value = _msdyn_trainedmodelaiconfigurationpareid_value;
        return _x;
    }

    @Property(name="msdyn_aiconfigurationid")
    @JsonIgnore
    public Optional<String> getMsdyn_aiconfigurationid() {
        return Optional.ofNullable(msdyn_aiconfigurationid);
    }

    public Msdyn_aiconfiguration withMsdyn_aiconfigurationid(String msdyn_aiconfigurationid) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aiconfigurationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_aiconfigurationid = msdyn_aiconfigurationid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Msdyn_aiconfiguration withOverwritetime(OffsetDateTime overwritetime) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aiconfiguration withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aiconfiguration with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aiconfiguration withStatuscode(Integer statuscode) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="msdyn_type")
    @JsonIgnore
    public Optional<Integer> getMsdyn_type() {
        return Optional.ofNullable(msdyn_type);
    }

    public Msdyn_aiconfiguration withMsdyn_type(Integer msdyn_type) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_type = msdyn_type;
        return _x;
    }

    @Property(name="_msdyn_aimodelid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_aimodelid_value() {
        return Optional.ofNullable(_msdyn_aimodelid_value);
    }

    public Msdyn_aiconfiguration with_msdyn_aimodelid_value(String _msdyn_aimodelid_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_aimodelid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._msdyn_aimodelid_value = _msdyn_aimodelid_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Msdyn_aiconfiguration withIscustomizable(BooleanManagedProperty iscustomizable) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aiconfiguration withVersionnumber(Long versionnumber) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Msdyn_aiconfiguration withComponentstate(Integer componentstate) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aiconfiguration withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="msdyn_schedulingoptions")
    @JsonIgnore
    public Optional<String> getMsdyn_schedulingoptions() {
        return Optional.ofNullable(msdyn_schedulingoptions);
    }

    public Msdyn_aiconfiguration withMsdyn_schedulingoptions(String msdyn_schedulingoptions) {
        Checks.checkIsAscii(msdyn_schedulingoptions);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_schedulingoptions");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_schedulingoptions = msdyn_schedulingoptions;
        return _x;
    }

    @Property(name="msdyn_aiconfigurationidunique")
    @JsonIgnore
    public Optional<String> getMsdyn_aiconfigurationidunique() {
        return Optional.ofNullable(msdyn_aiconfigurationidunique);
    }

    public Msdyn_aiconfiguration withMsdyn_aiconfigurationidunique(String msdyn_aiconfigurationidunique) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aiconfigurationidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_aiconfigurationidunique = msdyn_aiconfigurationidunique;
        return _x;
    }

    @Property(name="msdyn_modelprovisioningmetadata")
    @JsonIgnore
    public Optional<String> getMsdyn_modelprovisioningmetadata() {
        return Optional.ofNullable(msdyn_modelprovisioningmetadata);
    }

    public Msdyn_aiconfiguration withMsdyn_modelprovisioningmetadata(String msdyn_modelprovisioningmetadata) {
        Checks.checkIsAscii(msdyn_modelprovisioningmetadata);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_modelprovisioningmetadata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_modelprovisioningmetadata = msdyn_modelprovisioningmetadata;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Msdyn_aiconfiguration withIsmanaged(Boolean ismanaged) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aiconfiguration withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aiconfiguration with_modifiedby_value(String _modifiedby_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aiconfiguration withStatecode(Integer statecode) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="msdyn_modelrundataspecification")
    @JsonIgnore
    public Optional<String> getMsdyn_modelrundataspecification() {
        return Optional.ofNullable(msdyn_modelrundataspecification);
    }

    public Msdyn_aiconfiguration withMsdyn_modelrundataspecification(String msdyn_modelrundataspecification) {
        Checks.checkIsAscii(msdyn_modelrundataspecification);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_modelrundataspecification");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_modelrundataspecification = msdyn_modelrundataspecification;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aiconfiguration with_owninguser_value(String _owninguser_value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="msdyn_templateversion")
    @JsonIgnore
    public Optional<Integer> getMsdyn_templateversion() {
        return Optional.ofNullable(msdyn_templateversion);
    }

    public Msdyn_aiconfiguration withMsdyn_templateversion(Integer msdyn_templateversion) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_templateversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_templateversion = msdyn_templateversion;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Msdyn_aiconfiguration withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="msdyn_modelperformance")
    @JsonIgnore
    public Optional<String> getMsdyn_modelperformance() {
        return Optional.ofNullable(msdyn_modelperformance);
    }

    public Msdyn_aiconfiguration withMsdyn_modelperformance(String msdyn_modelperformance) {
        Checks.checkIsAscii(msdyn_modelperformance);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_modelperformance");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_modelperformance = msdyn_modelperformance;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_aiconfiguration withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_minoriterationnumber")
    @JsonIgnore
    public Optional<Integer> getMsdyn_minoriterationnumber() {
        return Optional.ofNullable(msdyn_minoriterationnumber);
    }

    public Msdyn_aiconfiguration withMsdyn_minoriterationnumber(Integer msdyn_minoriterationnumber) {
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = changedFields.add("msdyn_minoriterationnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiconfiguration");
        _x.msdyn_minoriterationnumber = msdyn_minoriterationnumber;
        return _x;
    }

    public Msdyn_aiconfiguration withUnmappedField(String name, String value) {
        Msdyn_aiconfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aiconfiguration_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aiconfiguration_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aiconfiguration_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aiconfiguration_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aiconfiguration_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aiconfiguration_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getMsdyn_aiconfiguration_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_FileAttachments"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_FileAttachments"));
    }

    @NavigationProperty(name="msdyn_TrainedModelAIConfigurationPareId")
    @JsonIgnore
    public Msdyn_aiconfigurationRequest getMsdyn_TrainedModelAIConfigurationPareId() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_TrainedModelAIConfigurationPareId"), RequestHelper.getValue(unmappedFields, "msdyn_TrainedModelAIConfigurationPareId"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_msdyn_aiconfiguration")
    @JsonIgnore
    public Msdyn_aiconfigurationCollectionRequest getMsdyn_aiconfiguration_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_msdyn_aiconfiguration"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_msdyn_aiconfiguration"));
    }

    @NavigationProperty(name="msdyn_CreatedFromConfigurationId")
    @JsonIgnore
    public Msdyn_aiconfigurationRequest getMsdyn_CreatedFromConfigurationId() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_CreatedFromConfigurationId"), RequestHelper.getValue(unmappedFields, "msdyn_CreatedFromConfigurationId"));
    }

    @NavigationProperty(name="msdyn_createdfromconfiguration_msdyn_toconfiguration")
    @JsonIgnore
    public Msdyn_aiconfigurationCollectionRequest getMsdyn_createdfromconfiguration_msdyn_toconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("msdyn_createdfromconfiguration_msdyn_toconfiguration"), RequestHelper.getValue(unmappedFields, "msdyn_createdfromconfiguration_msdyn_toconfiguration"));
    }

    @NavigationProperty(name="msdyn_AIModelId")
    @JsonIgnore
    public Msdyn_aimodelRequest getMsdyn_AIModelId() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("msdyn_AIModelId"), RequestHelper.getValue(unmappedFields, "msdyn_AIModelId"));
    }

    @NavigationProperty(name="msdyn_aiconfiguration_msdyn_aiodtrainingimage")
    @JsonIgnore
    public Msdyn_aiodtrainingimageCollectionRequest getMsdyn_aiconfiguration_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("msdyn_aiconfiguration_msdyn_aiodtrainingimage"), RequestHelper.getValue(unmappedFields, "msdyn_aiconfiguration_msdyn_aiodtrainingimage"));
    }

    @NavigationProperty(name="msdyn_aiodlabel_msdyn_aiconfiguration")
    @JsonIgnore
    public Msdyn_aiodlabelCollectionRequest getMsdyn_aiodlabel_msdyn_aiconfiguration() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("msdyn_aiodlabel_msdyn_aiconfiguration"), RequestHelper.getValue(unmappedFields, "msdyn_aiodlabel_msdyn_aiconfiguration"));
    }

    @NavigationProperty(name="msdyn_msdyn_aiconfiguration_msdyn_aifptrainingdocument_AIConfigurationId")
    @JsonIgnore
    public Msdyn_aifptrainingdocumentCollectionRequest getMsdyn_msdyn_aiconfiguration_msdyn_aifptrainingdocument_AIConfigurationId() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_aiconfiguration_msdyn_aifptrainingdocument_AIConfigurationId"), RequestHelper.getValue(unmappedFields, "msdyn_msdyn_aiconfiguration_msdyn_aifptrainingdocument_AIConfigurationId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiconfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiconfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiconfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aiconfiguration _copy() {
        Msdyn_aiconfiguration _x = new Msdyn_aiconfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutionid = solutionid;
        _x.msdyn_customconfiguration = msdyn_customconfiguration;
        _x.msdyn_resourceinfo = msdyn_resourceinfo;
        _x._ownerid_value = _ownerid_value;
        _x.msdyn_modeldata = msdyn_modeldata;
        _x._owningteam_value = _owningteam_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.createdon = createdon;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_lasttrainorrundate = msdyn_lasttrainorrundate;
        _x.msdyn_databinding = msdyn_databinding;
        _x.msdyn_lasterrors = msdyn_lasterrors;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._createdby_value = _createdby_value;
        _x.msdyn_modelglobalexplainability = msdyn_modelglobalexplainability;
        _x.msdyn_model_name = msdyn_model_name;
        _x.msdyn_majoriterationnumber = msdyn_majoriterationnumber;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.msdyn_modelprovisioningstatus = msdyn_modelprovisioningstatus;
        _x.msdyn_model = msdyn_model;
        _x.msdyn_runconfiguration = msdyn_runconfiguration;
        _x._msdyn_createdfromconfigurationid_value = _msdyn_createdfromconfigurationid_value;
        _x._msdyn_trainedmodelaiconfigurationpareid_value = _msdyn_trainedmodelaiconfigurationpareid_value;
        _x.msdyn_aiconfigurationid = msdyn_aiconfigurationid;
        _x.overwritetime = overwritetime;
        _x.importsequencenumber = importsequencenumber;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.statuscode = statuscode;
        _x.msdyn_type = msdyn_type;
        _x._msdyn_aimodelid_value = _msdyn_aimodelid_value;
        _x.iscustomizable = iscustomizable;
        _x.versionnumber = versionnumber;
        _x.componentstate = componentstate;
        _x.modifiedon = modifiedon;
        _x.msdyn_schedulingoptions = msdyn_schedulingoptions;
        _x.msdyn_aiconfigurationidunique = msdyn_aiconfigurationidunique;
        _x.msdyn_modelprovisioningmetadata = msdyn_modelprovisioningmetadata;
        _x.ismanaged = ismanaged;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._modifiedby_value = _modifiedby_value;
        _x.statecode = statecode;
        _x.msdyn_modelrundataspecification = msdyn_modelrundataspecification;
        _x._owninguser_value = _owninguser_value;
        _x.msdyn_templateversion = msdyn_templateversion;
        _x.introducedversion = introducedversion;
        _x.msdyn_modelperformance = msdyn_modelperformance;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_minoriterationnumber = msdyn_minoriterationnumber;
        return _x;
    }

    @Action(name = "CancelTraining")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CancelTrainingResponse> cancelTraining(String version) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CancelTrainingResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CancelTraining"), CancelTrainingResponse.class, _parameters);
    }

    @Action(name = "PublishAIConfiguration")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PublishAIConfigurationResponse> publishAIConfiguration(String version) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PublishAIConfigurationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PublishAIConfiguration"), PublishAIConfigurationResponse.class, _parameters);
    }

    @Action(name = "QuickTest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<QuickTestResponse> quickTest(String version, String request, Crmbaseentity requestv2) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("request", "Edm.String", Checks.checkIsAscii(request))
            .put("requestv2", "Microsoft.Dynamics.CRM.crmbaseentity", requestv2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<QuickTestResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.QuickTest"), QuickTestResponse.class, _parameters);
    }

    @Action(name = "ScheduleTraining")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ScheduleTrainingResponse> scheduleTraining(String version) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ScheduleTrainingResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ScheduleTraining"), ScheduleTrainingResponse.class, _parameters);
    }

    @Action(name = "Train")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrainResponse> train(String version) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrainResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Train"), TrainResponse.class, _parameters);
    }

    @Action(name = "UnpublishAIConfiguration")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UnpublishAIConfigurationResponse> unpublishAIConfiguration(String version) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UnpublishAIConfigurationResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UnpublishAIConfiguration"), UnpublishAIConfigurationResponse.class, _parameters);
    }

    @Action(name = "UnscheduleTraining")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UnscheduleTrainingResponse> unscheduleTraining(String version) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UnscheduleTrainingResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UnscheduleTraining"), UnscheduleTrainingResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aiconfiguration[");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("msdyn_customconfiguration=");
        b.append(this.msdyn_customconfiguration);
        b.append(", ");
        b.append("msdyn_resourceinfo=");
        b.append(this.msdyn_resourceinfo);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("msdyn_modeldata=");
        b.append(this.msdyn_modeldata);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_lasttrainorrundate=");
        b.append(this.msdyn_lasttrainorrundate);
        b.append(", ");
        b.append("msdyn_databinding=");
        b.append(this.msdyn_databinding);
        b.append(", ");
        b.append("msdyn_lasterrors=");
        b.append(this.msdyn_lasterrors);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("msdyn_modelglobalexplainability=");
        b.append(this.msdyn_modelglobalexplainability);
        b.append(", ");
        b.append("msdyn_model_name=");
        b.append(this.msdyn_model_name);
        b.append(", ");
        b.append("msdyn_majoriterationnumber=");
        b.append(this.msdyn_majoriterationnumber);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("msdyn_modelprovisioningstatus=");
        b.append(this.msdyn_modelprovisioningstatus);
        b.append(", ");
        b.append("msdyn_model=");
        b.append(this.msdyn_model);
        b.append(", ");
        b.append("msdyn_runconfiguration=");
        b.append(this.msdyn_runconfiguration);
        b.append(", ");
        b.append("_msdyn_createdfromconfigurationid_value=");
        b.append(this._msdyn_createdfromconfigurationid_value);
        b.append(", ");
        b.append("_msdyn_trainedmodelaiconfigurationpareid_value=");
        b.append(this._msdyn_trainedmodelaiconfigurationpareid_value);
        b.append(", ");
        b.append("msdyn_aiconfigurationid=");
        b.append(this.msdyn_aiconfigurationid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("msdyn_type=");
        b.append(this.msdyn_type);
        b.append(", ");
        b.append("_msdyn_aimodelid_value=");
        b.append(this._msdyn_aimodelid_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("msdyn_schedulingoptions=");
        b.append(this.msdyn_schedulingoptions);
        b.append(", ");
        b.append("msdyn_aiconfigurationidunique=");
        b.append(this.msdyn_aiconfigurationidunique);
        b.append(", ");
        b.append("msdyn_modelprovisioningmetadata=");
        b.append(this.msdyn_modelprovisioningmetadata);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("msdyn_modelrundataspecification=");
        b.append(this.msdyn_modelrundataspecification);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("msdyn_templateversion=");
        b.append(this.msdyn_templateversion);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("msdyn_modelperformance=");
        b.append(this.msdyn_modelperformance);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_minoriterationnumber=");
        b.append(this.msdyn_minoriterationnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
