package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.EntityanalyticsconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentconfigurationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "logicalcollectionname", 
    "parentcontrollingattributename", 
    "externalcollectionname", 
    "extensiontablename", 
    "basetablename", 
    "overwritetime", 
    "entityid", 
    "physicalname", 
    "entitysetname", 
    "originallocalizedcollectionname", 
    "collectionname", 
    "externalname", 
    "reportviewname", 
    "addresstablename", 
    "solutionid", 
    "componentstate", 
    "name", 
    "logicalname", 
    "originallocalizedname"})
@JsonInclude(Include.NON_NULL)
public class Entity extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.entity";
    }

    @JsonProperty("logicalcollectionname")
    protected String logicalcollectionname;

    @JsonProperty("parentcontrollingattributename")
    protected String parentcontrollingattributename;

    @JsonProperty("externalcollectionname")
    protected String externalcollectionname;

    @JsonProperty("extensiontablename")
    protected String extensiontablename;

    @JsonProperty("basetablename")
    protected String basetablename;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("entityid")
    protected String entityid;

    @JsonProperty("physicalname")
    protected String physicalname;

    @JsonProperty("entitysetname")
    protected String entitysetname;

    @JsonProperty("originallocalizedcollectionname")
    protected String originallocalizedcollectionname;

    @JsonProperty("collectionname")
    protected String collectionname;

    @JsonProperty("externalname")
    protected String externalname;

    @JsonProperty("reportviewname")
    protected String reportviewname;

    @JsonProperty("addresstablename")
    protected String addresstablename;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("logicalname")
    protected String logicalname;

    @JsonProperty("originallocalizedname")
    protected String originallocalizedname;

    protected Entity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntity() {
        return new Builder();
    }

    public static final class Builder {
        private String logicalcollectionname;
        private String parentcontrollingattributename;
        private String externalcollectionname;
        private String extensiontablename;
        private String basetablename;
        private OffsetDateTime overwritetime;
        private String entityid;
        private String physicalname;
        private String entitysetname;
        private String originallocalizedcollectionname;
        private String collectionname;
        private String externalname;
        private String reportviewname;
        private String addresstablename;
        private String solutionid;
        private Integer componentstate;
        private String name;
        private String logicalname;
        private String originallocalizedname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder logicalcollectionname(String logicalcollectionname) {
            this.logicalcollectionname = logicalcollectionname;
            this.changedFields = changedFields.add("logicalcollectionname");
            return this;
        }

        public Builder parentcontrollingattributename(String parentcontrollingattributename) {
            this.parentcontrollingattributename = parentcontrollingattributename;
            this.changedFields = changedFields.add("parentcontrollingattributename");
            return this;
        }

        public Builder externalcollectionname(String externalcollectionname) {
            this.externalcollectionname = externalcollectionname;
            this.changedFields = changedFields.add("externalcollectionname");
            return this;
        }

        public Builder extensiontablename(String extensiontablename) {
            this.extensiontablename = extensiontablename;
            this.changedFields = changedFields.add("extensiontablename");
            return this;
        }

        public Builder basetablename(String basetablename) {
            this.basetablename = basetablename;
            this.changedFields = changedFields.add("basetablename");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder entityid(String entityid) {
            this.entityid = entityid;
            this.changedFields = changedFields.add("entityid");
            return this;
        }

        public Builder physicalname(String physicalname) {
            this.physicalname = physicalname;
            this.changedFields = changedFields.add("physicalname");
            return this;
        }

        public Builder entitysetname(String entitysetname) {
            this.entitysetname = entitysetname;
            this.changedFields = changedFields.add("entitysetname");
            return this;
        }

        public Builder originallocalizedcollectionname(String originallocalizedcollectionname) {
            this.originallocalizedcollectionname = originallocalizedcollectionname;
            this.changedFields = changedFields.add("originallocalizedcollectionname");
            return this;
        }

        public Builder collectionname(String collectionname) {
            this.collectionname = collectionname;
            this.changedFields = changedFields.add("collectionname");
            return this;
        }

        public Builder externalname(String externalname) {
            this.externalname = externalname;
            this.changedFields = changedFields.add("externalname");
            return this;
        }

        public Builder reportviewname(String reportviewname) {
            this.reportviewname = reportviewname;
            this.changedFields = changedFields.add("reportviewname");
            return this;
        }

        public Builder addresstablename(String addresstablename) {
            this.addresstablename = addresstablename;
            this.changedFields = changedFields.add("addresstablename");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder logicalname(String logicalname) {
            this.logicalname = logicalname;
            this.changedFields = changedFields.add("logicalname");
            return this;
        }

        public Builder originallocalizedname(String originallocalizedname) {
            this.originallocalizedname = originallocalizedname;
            this.changedFields = changedFields.add("originallocalizedname");
            return this;
        }

        public Entity build() {
            Entity _x = new Entity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.entity";
            _x.logicalcollectionname = logicalcollectionname;
            _x.parentcontrollingattributename = parentcontrollingattributename;
            _x.externalcollectionname = externalcollectionname;
            _x.extensiontablename = extensiontablename;
            _x.basetablename = basetablename;
            _x.overwritetime = overwritetime;
            _x.entityid = entityid;
            _x.physicalname = physicalname;
            _x.entitysetname = entitysetname;
            _x.originallocalizedcollectionname = originallocalizedcollectionname;
            _x.collectionname = collectionname;
            _x.externalname = externalname;
            _x.reportviewname = reportviewname;
            _x.addresstablename = addresstablename;
            _x.solutionid = solutionid;
            _x.componentstate = componentstate;
            _x.name = name;
            _x.logicalname = logicalname;
            _x.originallocalizedname = originallocalizedname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && entityid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(entityid.toString()));
        }
    }

    @Property(name="logicalcollectionname")
    @JsonIgnore
    public Optional<String> getLogicalcollectionname() {
        return Optional.ofNullable(logicalcollectionname);
    }

    public Entity withLogicalcollectionname(String logicalcollectionname) {
        Checks.checkIsAscii(logicalcollectionname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("logicalcollectionname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.logicalcollectionname = logicalcollectionname;
        return _x;
    }

    @Property(name="parentcontrollingattributename")
    @JsonIgnore
    public Optional<String> getParentcontrollingattributename() {
        return Optional.ofNullable(parentcontrollingattributename);
    }

    public Entity withParentcontrollingattributename(String parentcontrollingattributename) {
        Checks.checkIsAscii(parentcontrollingattributename);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("parentcontrollingattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.parentcontrollingattributename = parentcontrollingattributename;
        return _x;
    }

    @Property(name="externalcollectionname")
    @JsonIgnore
    public Optional<String> getExternalcollectionname() {
        return Optional.ofNullable(externalcollectionname);
    }

    public Entity withExternalcollectionname(String externalcollectionname) {
        Checks.checkIsAscii(externalcollectionname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("externalcollectionname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.externalcollectionname = externalcollectionname;
        return _x;
    }

    @Property(name="extensiontablename")
    @JsonIgnore
    public Optional<String> getExtensiontablename() {
        return Optional.ofNullable(extensiontablename);
    }

    public Entity withExtensiontablename(String extensiontablename) {
        Checks.checkIsAscii(extensiontablename);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("extensiontablename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.extensiontablename = extensiontablename;
        return _x;
    }

    @Property(name="basetablename")
    @JsonIgnore
    public Optional<String> getBasetablename() {
        return Optional.ofNullable(basetablename);
    }

    public Entity withBasetablename(String basetablename) {
        Checks.checkIsAscii(basetablename);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("basetablename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.basetablename = basetablename;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Entity withOverwritetime(OffsetDateTime overwritetime) {
        Entity _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="entityid")
    @JsonIgnore
    public Optional<String> getEntityid() {
        return Optional.ofNullable(entityid);
    }

    public Entity withEntityid(String entityid) {
        Entity _x = _copy();
        _x.changedFields = changedFields.add("entityid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.entityid = entityid;
        return _x;
    }

    @Property(name="physicalname")
    @JsonIgnore
    public Optional<String> getPhysicalname() {
        return Optional.ofNullable(physicalname);
    }

    public Entity withPhysicalname(String physicalname) {
        Checks.checkIsAscii(physicalname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("physicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.physicalname = physicalname;
        return _x;
    }

    @Property(name="entitysetname")
    @JsonIgnore
    public Optional<String> getEntitysetname() {
        return Optional.ofNullable(entitysetname);
    }

    public Entity withEntitysetname(String entitysetname) {
        Checks.checkIsAscii(entitysetname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("entitysetname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.entitysetname = entitysetname;
        return _x;
    }

    @Property(name="originallocalizedcollectionname")
    @JsonIgnore
    public Optional<String> getOriginallocalizedcollectionname() {
        return Optional.ofNullable(originallocalizedcollectionname);
    }

    public Entity withOriginallocalizedcollectionname(String originallocalizedcollectionname) {
        Checks.checkIsAscii(originallocalizedcollectionname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("originallocalizedcollectionname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.originallocalizedcollectionname = originallocalizedcollectionname;
        return _x;
    }

    @Property(name="collectionname")
    @JsonIgnore
    public Optional<String> getCollectionname() {
        return Optional.ofNullable(collectionname);
    }

    public Entity withCollectionname(String collectionname) {
        Checks.checkIsAscii(collectionname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("collectionname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.collectionname = collectionname;
        return _x;
    }

    @Property(name="externalname")
    @JsonIgnore
    public Optional<String> getExternalname() {
        return Optional.ofNullable(externalname);
    }

    public Entity withExternalname(String externalname) {
        Checks.checkIsAscii(externalname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("externalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.externalname = externalname;
        return _x;
    }

    @Property(name="reportviewname")
    @JsonIgnore
    public Optional<String> getReportviewname() {
        return Optional.ofNullable(reportviewname);
    }

    public Entity withReportviewname(String reportviewname) {
        Checks.checkIsAscii(reportviewname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("reportviewname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.reportviewname = reportviewname;
        return _x;
    }

    @Property(name="addresstablename")
    @JsonIgnore
    public Optional<String> getAddresstablename() {
        return Optional.ofNullable(addresstablename);
    }

    public Entity withAddresstablename(String addresstablename) {
        Checks.checkIsAscii(addresstablename);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("addresstablename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.addresstablename = addresstablename;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Entity withSolutionid(String solutionid) {
        Entity _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Entity withComponentstate(Integer componentstate) {
        Entity _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Entity withName(String name) {
        Checks.checkIsAscii(name);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.name = name;
        return _x;
    }

    @Property(name="logicalname")
    @JsonIgnore
    public Optional<String> getLogicalname() {
        return Optional.ofNullable(logicalname);
    }

    public Entity withLogicalname(String logicalname) {
        Checks.checkIsAscii(logicalname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("logicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.logicalname = logicalname;
        return _x;
    }

    @Property(name="originallocalizedname")
    @JsonIgnore
    public Optional<String> getOriginallocalizedname() {
        return Optional.ofNullable(originallocalizedname);
    }

    public Entity withOriginallocalizedname(String originallocalizedname) {
        Checks.checkIsAscii(originallocalizedname);
        Entity _x = _copy();
        _x.changedFields = changedFields.add("originallocalizedname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entity");
        _x.originallocalizedname = originallocalizedname;
        return _x;
    }

    public Entity withUnmappedField(String name, String value) {
        Entity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="entity_solutioncomponentconfiguration")
    @JsonIgnore
    public SolutioncomponentconfigurationCollectionRequest getEntity_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationCollectionRequest(
                        contextPath.addSegment("entity_solutioncomponentconfiguration"), RequestHelper.getValue(unmappedFields, "entity_solutioncomponentconfiguration"));
    }

    @NavigationProperty(name="entity_entityanalyticsconfig")
    @JsonIgnore
    public EntityanalyticsconfigCollectionRequest getEntity_entityanalyticsconfig() {
        return new EntityanalyticsconfigCollectionRequest(
                        contextPath.addSegment("entity_entityanalyticsconfig"), RequestHelper.getValue(unmappedFields, "entity_entityanalyticsconfig"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Entity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Entity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Entity _copy() {
        Entity _x = new Entity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.logicalcollectionname = logicalcollectionname;
        _x.parentcontrollingattributename = parentcontrollingattributename;
        _x.externalcollectionname = externalcollectionname;
        _x.extensiontablename = extensiontablename;
        _x.basetablename = basetablename;
        _x.overwritetime = overwritetime;
        _x.entityid = entityid;
        _x.physicalname = physicalname;
        _x.entitysetname = entitysetname;
        _x.originallocalizedcollectionname = originallocalizedcollectionname;
        _x.collectionname = collectionname;
        _x.externalname = externalname;
        _x.reportviewname = reportviewname;
        _x.addresstablename = addresstablename;
        _x.solutionid = solutionid;
        _x.componentstate = componentstate;
        _x.name = name;
        _x.logicalname = logicalname;
        _x.originallocalizedname = originallocalizedname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Entity[");
        b.append("logicalcollectionname=");
        b.append(this.logicalcollectionname);
        b.append(", ");
        b.append("parentcontrollingattributename=");
        b.append(this.parentcontrollingattributename);
        b.append(", ");
        b.append("externalcollectionname=");
        b.append(this.externalcollectionname);
        b.append(", ");
        b.append("extensiontablename=");
        b.append(this.extensiontablename);
        b.append(", ");
        b.append("basetablename=");
        b.append(this.basetablename);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("entityid=");
        b.append(this.entityid);
        b.append(", ");
        b.append("physicalname=");
        b.append(this.physicalname);
        b.append(", ");
        b.append("entitysetname=");
        b.append(this.entitysetname);
        b.append(", ");
        b.append("originallocalizedcollectionname=");
        b.append(this.originallocalizedcollectionname);
        b.append(", ");
        b.append("collectionname=");
        b.append(this.collectionname);
        b.append(", ");
        b.append("externalname=");
        b.append(this.externalname);
        b.append(", ");
        b.append("reportviewname=");
        b.append(this.reportviewname);
        b.append(", ");
        b.append("addresstablename=");
        b.append(this.addresstablename);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("logicalname=");
        b.append(this.logicalname);
        b.append(", ");
        b.append("originallocalizedname=");
        b.append(this.originallocalizedname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
