package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Path", 
    "Name", 
    "DisplayName", 
    "WebResourceType", 
    "Guid"})
@JsonInclude(Include.NON_NULL)
public class WebResourceInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Path")
    protected String path;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("DisplayName")
    protected String displayName;

    @JsonProperty("WebResourceType")
    protected Integer webResourceType;

    @JsonProperty("Guid")
    protected String guid;

    protected WebResourceInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.WebResourceInfo";
    }

    @Property(name="Path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    public WebResourceInfo withPath(String path) {
        Checks.checkIsAscii(path);
        WebResourceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.path = path;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public WebResourceInfo withName(String name) {
        Checks.checkIsAscii(name);
        WebResourceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.name = name;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public WebResourceInfo withDisplayName(String displayName) {
        Checks.checkIsAscii(displayName);
        WebResourceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="WebResourceType")
    @JsonIgnore
    public Optional<Integer> getWebResourceType() {
        return Optional.ofNullable(webResourceType);
    }

    public WebResourceInfo withWebResourceType(Integer webResourceType) {
        WebResourceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.webResourceType = webResourceType;
        return _x;
    }

    @Property(name="Guid")
    @JsonIgnore
    public Optional<String> getGuid() {
        return Optional.ofNullable(guid);
    }

    public WebResourceInfo withGuid(String guid) {
        Checks.checkIsAscii(guid);
        WebResourceInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.guid = guid;
        return _x;
    }

    public WebResourceInfo withUnmappedField(String name, String value) {
        WebResourceInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String path;
        private String name;
        private String displayName;
        private Integer webResourceType;
        private String guid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("Path");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder webResourceType(Integer webResourceType) {
            this.webResourceType = webResourceType;
            this.changedFields = changedFields.add("WebResourceType");
            return this;
        }

        public Builder guid(String guid) {
            this.guid = guid;
            this.changedFields = changedFields.add("Guid");
            return this;
        }

        public WebResourceInfo build() {
            WebResourceInfo _x = new WebResourceInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.WebResourceInfo";
            _x.path = path;
            _x.name = name;
            _x.displayName = displayName;
            _x.webResourceType = webResourceType;
            _x.guid = guid;
            return _x;
        }
    }

    private WebResourceInfo _copy() {
        WebResourceInfo _x = new WebResourceInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.path = path;
        _x.name = name;
        _x.displayName = displayName;
        _x.webResourceType = webResourceType;
        _x.guid = guid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WebResourceInfo[");
        b.append("Path=");
        b.append(this.path);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("WebResourceType=");
        b.append(this.webResourceType);
        b.append(", ");
        b.append("Guid=");
        b.append(this.guid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
