package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.LayerDesiredOrderType;

@JsonPropertyOrder({
    "@odata.type", 
    "Type", 
    "Solutions"})
@JsonInclude(Include.NON_NULL)
public class LayerDesiredOrder implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Type")
    protected LayerDesiredOrderType type;

    @JsonProperty("Solutions")
    protected List<SolutionInfo> solutions;

    @JsonProperty("Solutions@nextLink")
    protected String solutionsNextLink;

    protected LayerDesiredOrder() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LayerDesiredOrder";
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<LayerDesiredOrderType> getType() {
        return Optional.ofNullable(type);
    }

    public LayerDesiredOrder withType(LayerDesiredOrderType type) {
        LayerDesiredOrder _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LayerDesiredOrder");
        _x.type = type;
        return _x;
    }

    @Property(name="Solutions")
    @JsonIgnore
    public CollectionPage<SolutionInfo> getSolutions() {
        return new CollectionPage<SolutionInfo>(contextPath, SolutionInfo.class, this.solutions, Optional.ofNullable(solutionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Solutions")
    @JsonIgnore
    public CollectionPage<SolutionInfo> getSolutions(HttpRequestOptions options) {
        return new CollectionPage<SolutionInfo>(contextPath, SolutionInfo.class, this.solutions, Optional.ofNullable(solutionsNextLink), Collections.emptyList(), options);
    }

    public LayerDesiredOrder withUnmappedField(String name, String value) {
        LayerDesiredOrder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LayerDesiredOrderType type;
        private List<SolutionInfo> solutions;
        private String solutionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder type(LayerDesiredOrderType type) {
            this.type = type;
            this.changedFields = changedFields.add("Type");
            return this;
        }

        public Builder solutions(List<SolutionInfo> solutions) {
            this.solutions = solutions;
            this.changedFields = changedFields.add("Solutions");
            return this;
        }

        public Builder solutions(SolutionInfo... solutions) {
            return solutions(Arrays.asList(solutions));
        }

        public Builder solutionsNextLink(String solutionsNextLink) {
            this.solutionsNextLink = solutionsNextLink;
            this.changedFields = changedFields.add("Solutions");
            return this;
        }

        public LayerDesiredOrder build() {
            LayerDesiredOrder _x = new LayerDesiredOrder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LayerDesiredOrder";
            _x.type = type;
            _x.solutions = solutions;
            _x.solutionsNextLink = solutionsNextLink;
            return _x;
        }
    }

    private LayerDesiredOrder _copy() {
        LayerDesiredOrder _x = new LayerDesiredOrder();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.type = type;
        _x.solutions = solutions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LayerDesiredOrder[");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("Solutions=");
        b.append(this.solutions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
