/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.enums.ConditionOperator;

@JsonPropertyOrder(value={"@odata.type", "EntityName", "CompareColumns", "AttributeName", "Operator", "Values"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConditionExpression
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityName")
    protected String entityName;
    @JsonProperty(value="CompareColumns")
    protected Boolean compareColumns;
    @JsonProperty(value="AttributeName")
    protected String attributeName;
    @JsonProperty(value="Operator")
    protected ConditionOperator operator;
    @JsonProperty(value="Values")
    protected List<Object> values;
    @JsonProperty(value="Values@nextLink")
    protected String valuesNextLink;

    protected ConditionExpression() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ConditionExpression";
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(this.entityName);
    }

    public ConditionExpression withEntityName(String entityName) {
        Checks.checkIsAscii((String)entityName);
        ConditionExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ConditionExpression");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="CompareColumns")
    @JsonIgnore
    public Optional<Boolean> getCompareColumns() {
        return Optional.ofNullable(this.compareColumns);
    }

    public ConditionExpression withCompareColumns(Boolean compareColumns) {
        ConditionExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ConditionExpression");
        _x.compareColumns = compareColumns;
        return _x;
    }

    @Property(name="AttributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(this.attributeName);
    }

    public ConditionExpression withAttributeName(String attributeName) {
        Checks.checkIsAscii((String)attributeName);
        ConditionExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ConditionExpression");
        _x.attributeName = attributeName;
        return _x;
    }

    @Property(name="Operator")
    @JsonIgnore
    public Optional<ConditionOperator> getOperator() {
        return Optional.ofNullable(this.operator);
    }

    public ConditionExpression withOperator(ConditionOperator operator) {
        ConditionExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ConditionExpression");
        _x.operator = operator;
        return _x;
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<Object> getValues() {
        return new CollectionPage(this.contextPath, Object.class, this.values, Optional.ofNullable(this.valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<Object> getValues(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, Object.class, this.values, Optional.ofNullable(this.valuesNextLink), Collections.emptyList(), options);
    }

    public ConditionExpression withUnmappedField(String name, String value) {
        ConditionExpression _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, java.lang.Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ConditionExpression _copy() {
        ConditionExpression _x = new ConditionExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entityName = this.entityName;
        _x.compareColumns = this.compareColumns;
        _x.attributeName = this.attributeName;
        _x.operator = this.operator;
        _x.values = this.values;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionExpression[");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("CompareColumns=");
        b.append(this.compareColumns);
        b.append(", ");
        b.append("AttributeName=");
        b.append(this.attributeName);
        b.append(", ");
        b.append("Operator=");
        b.append((java.lang.Object)this.operator);
        b.append(", ");
        b.append("Values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String entityName;
        private Boolean compareColumns;
        private String attributeName;
        private ConditionOperator operator;
        private List<Object> values;
        private String valuesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = this.changedFields.add("EntityName");
            return this;
        }

        public Builder compareColumns(Boolean compareColumns) {
            this.compareColumns = compareColumns;
            this.changedFields = this.changedFields.add("CompareColumns");
            return this;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = this.changedFields.add("AttributeName");
            return this;
        }

        public Builder operator(ConditionOperator operator) {
            this.operator = operator;
            this.changedFields = this.changedFields.add("Operator");
            return this;
        }

        public Builder values(List<Object> values) {
            this.values = values;
            this.changedFields = this.changedFields.add("Values");
            return this;
        }

        public Builder values(Object ... values) {
            return this.values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = this.changedFields.add("Values");
            return this;
        }

        public ConditionExpression build() {
            ConditionExpression _x = new ConditionExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ConditionExpression";
            _x.entityName = this.entityName;
            _x.compareColumns = this.compareColumns;
            _x.attributeName = this.attributeName;
            _x.operator = this.operator;
            _x.values = this.values;
            _x.valuesNextLink = this.valuesNextLink;
            return _x;
        }
    }
}

