package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum XrmDateTimeGrouping implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Day")
    DAY("Day", "1"),

    @JsonProperty("Week")
    WEEK("Week", "2"),

    @JsonProperty("Month")
    MONTH("Month", "3"),

    @JsonProperty("Quarter")
    QUARTER("Quarter", "4"),

    @JsonProperty("Year")
    YEAR("Year", "5"),

    @JsonProperty("FiscalPeriod")
    FISCAL_PERIOD("FiscalPeriod", "6"),

    @JsonProperty("FiscalYear")
    FISCAL_YEAR("FiscalYear", "7");

    private final String name;
    private final String value;

    private XrmDateTimeGrouping(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
