package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RecentlyViewedRecordType implements Enum {

    @JsonProperty("Entity")
    ENTITY("Entity", "0"),

    @JsonProperty("Grid")
    GRID("Grid", "1"),

    @JsonProperty("Isv")
    ISV("Isv", "2"),

    @JsonProperty("Invalid")
    INVALID("Invalid", "-1");

    private final String name;
    private final String value;

    private RecentlyViewedRecordType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
