package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MetadataConditionOperator implements Enum {

    @JsonProperty("Equals")
    EQUALS("Equals", "0"),

    @JsonProperty("NotEquals")
    NOT_EQUALS("NotEquals", "1"),

    @JsonProperty("In")
    IN("In", "2"),

    @JsonProperty("NotIn")
    NOT_IN("NotIn", "3"),

    @JsonProperty("GreaterThan")
    GREATER_THAN("GreaterThan", "4"),

    @JsonProperty("LessThan")
    LESS_THAN("LessThan", "5");

    private final String name;
    private final String value;

    private MetadataConditionOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
