package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedPropertyOperation implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Create")
    CREATE("Create", "1"),

    @JsonProperty("Update")
    UPDATE("Update", "2"),

    @JsonProperty("CreateUpdate")
    CREATE_UPDATE("CreateUpdate", "3"),

    @JsonProperty("Delete")
    DELETE("Delete", "4"),

    @JsonProperty("UpdateDelete")
    UPDATE_DELETE("UpdateDelete", "6"),

    @JsonProperty("All")
    ALL("All", "7");

    private final String name;
    private final String value;

    private ManagedPropertyOperation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
