package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AssociatedMenuGroup implements Enum {

    @JsonProperty("Details")
    DETAILS("Details", "0"),

    @JsonProperty("Sales")
    SALES("Sales", "1"),

    @JsonProperty("Service")
    SERVICE("Service", "2"),

    @JsonProperty("Marketing")
    MARKETING("Marketing", "3");

    private final String name;
    private final String value;

    private AssociatedMenuGroup(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
