package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Solutioncomponent;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentCollectionRequest;

@JsonIgnoreType
public class SolutioncomponentRequest extends EntityRequest<Solutioncomponent> {

    public SolutioncomponentRequest(ContextPath contextPath, Optional<Object> value) {
        super(Solutioncomponent.class, contextPath, value, false);
    }

    public SolutionRequest solutionid() {
        return new SolutionRequest(contextPath.addSegment("solutionid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SolutioncomponentRequest rootsolutioncomponentid_solutioncomponent() {
        return new SolutioncomponentRequest(contextPath.addSegment("rootsolutioncomponentid_solutioncomponent"), Optional.empty());
    }

    public SolutioncomponentCollectionRequest solutioncomponent_parent_solutioncomponent() {
        return new SolutioncomponentCollectionRequest(
                        contextPath.addSegment("solutioncomponent_parent_solutioncomponent"), Optional.empty());
    }

    public SolutioncomponentRequest solutioncomponent_parent_solutioncomponent(String solutioncomponentid) {
        return new SolutioncomponentRequest(contextPath.addSegment("solutioncomponent_parent_solutioncomponent").addKeys(new NameValue(solutioncomponentid.toString())), Optional.empty());
    }

}
