package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Processstageparameter;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ProcessstageparameterRequest extends EntityRequest<Processstageparameter> {

    public ProcessstageparameterRequest(ContextPath contextPath, Optional<Object> value) {
        super(Processstageparameter.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorCollectionRequest processstageparameter_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("processstageparameter_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest processstageparameter_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("processstageparameter_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest processstageparameter_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("processstageparameter_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest processstageparameter_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("processstageparameter_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest processstageparameter_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("processstageparameter_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest processstageparameter_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("processstageparameter_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest processstageparameter_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("processstageparameter_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest processstageparameter_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("processstageparameter_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest processstageparameter_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("processstageparameter_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest processstageparameter_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("processstageparameter_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest processstageparameter_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("processstageparameter_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest processstageparameter_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("processstageparameter_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public ProcessstageRequest processStageId() {
        return new ProcessstageRequest(contextPath.addSegment("ProcessStageId"), Optional.empty());
    }

}
