package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.OneToManyRelationshipMetadata;

@JsonIgnoreType
public class OneToManyRelationshipMetadataRequest extends EntityRequest<OneToManyRelationshipMetadata> {

    public OneToManyRelationshipMetadataRequest(ContextPath contextPath, Optional<Object> value) {
        super(OneToManyRelationshipMetadata.class, contextPath, value, false);
    }

    public LookupAttributeMetadataRequest lookup() {
        return new LookupAttributeMetadataRequest(contextPath.addSegment("Lookup"), Optional.empty());
    }

}
