package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.EntityMetadata;
import microsoft.dynamics.crm.entity.request.AttributeMetadataRequest;
import microsoft.dynamics.crm.entity.request.EntityKeyMetadataRequest;
import microsoft.dynamics.crm.entity.request.EntityMetadataRequest;
import microsoft.dynamics.crm.entity.request.ManyToManyRelationshipMetadataRequest;
import microsoft.dynamics.crm.entity.request.OneToManyRelationshipMetadataRequest;

public class EntityMetadataCollectionRequest extends CollectionPageEntityRequest<EntityMetadata, EntityMetadataRequest>{

    protected ContextPath contextPath;

    public EntityMetadataCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, EntityMetadata.class, cp -> new EntityMetadataRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AttributeMetadataCollectionRequest attributes() {
        return new AttributeMetadataCollectionRequest(contextPath.addSegment("Attributes"), Optional.empty());
    }

    public AttributeMetadataRequest attributes(String metadataId) {
        return new AttributeMetadataRequest(contextPath.addSegment("Attributes").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public ManyToManyRelationshipMetadataCollectionRequest manyToManyRelationships2() {
        return new ManyToManyRelationshipMetadataCollectionRequest(contextPath.addSegment("ManyToManyRelationships2"), Optional.empty());
    }

    public ManyToManyRelationshipMetadataRequest manyToManyRelationships2(String metadataId) {
        return new ManyToManyRelationshipMetadataRequest(contextPath.addSegment("ManyToManyRelationships2").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public OneToManyRelationshipMetadataCollectionRequest manyToOneRelationships2() {
        return new OneToManyRelationshipMetadataCollectionRequest(contextPath.addSegment("ManyToOneRelationships2"), Optional.empty());
    }

    public OneToManyRelationshipMetadataRequest manyToOneRelationships2(String metadataId) {
        return new OneToManyRelationshipMetadataRequest(contextPath.addSegment("ManyToOneRelationships2").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public OneToManyRelationshipMetadataCollectionRequest oneToManyRelationships2() {
        return new OneToManyRelationshipMetadataCollectionRequest(contextPath.addSegment("OneToManyRelationships2"), Optional.empty());
    }

    public OneToManyRelationshipMetadataRequest oneToManyRelationships2(String metadataId) {
        return new OneToManyRelationshipMetadataRequest(contextPath.addSegment("OneToManyRelationships2").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

    public EntityKeyMetadataCollectionRequest keys() {
        return new EntityKeyMetadataCollectionRequest(contextPath.addSegment("Keys"), Optional.empty());
    }

    public EntityKeyMetadataRequest keys(String metadataId) {
        return new EntityKeyMetadataRequest(contextPath.addSegment("Keys").addKeys(new NameValue(metadataId.toString())), Optional.empty());
    }

}
