package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Customcontrol;
import microsoft.dynamics.crm.entity.request.CustomcontrolRequest;
import microsoft.dynamics.crm.entity.request.CustomcontrolresourceRequest;

public class CustomcontrolCollectionRequest extends CollectionPageEntityRequest<Customcontrol, CustomcontrolRequest>{

    protected ContextPath contextPath;

    public CustomcontrolCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Customcontrol.class, cp -> new CustomcontrolRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CustomcontrolresourceCollectionRequest customcontrol_resource_id() {
        return new CustomcontrolresourceCollectionRequest(contextPath.addSegment("customcontrol_resource_id"), Optional.empty());
    }

    public CustomcontrolresourceRequest customcontrol_resource_id(String customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("customcontrol_resource_id").addKeys(new NameValue(customcontrolresourceid.toString())), Optional.empty());
    }

}
