package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.AttributeMetadata;
import microsoft.dynamics.crm.entity.request.AttributeMetadataRequest;

public class AttributeMetadataCollectionRequest extends CollectionPageEntityRequest<AttributeMetadata, AttributeMetadataRequest>{

    protected ContextPath contextPath;

    public AttributeMetadataCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AttributeMetadata.class, cp -> new AttributeMetadataRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
