package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Attachment;
import microsoft.dynamics.crm.entity.request.ActivitymimeattachmentRequest;
import microsoft.dynamics.crm.entity.request.AttachmentRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class AttachmentCollectionRequest extends CollectionPageEntityRequest<Attachment, AttachmentRequest>{

    protected ContextPath contextPath;

    public AttachmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Attachment.class, cp -> new AttachmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest attachment_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Attachment_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest attachment_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Attachment_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest attachment_activity_mime_attachments() {
        return new ActivitymimeattachmentCollectionRequest(contextPath.addSegment("attachment_activity_mime_attachments"), Optional.empty());
    }

    public ActivitymimeattachmentRequest attachment_activity_mime_attachments(String activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("attachment_activity_mime_attachments").addKeys(new NameValue(activitymimeattachmentid.toString())), Optional.empty());
    }

}
