package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "versionnumber", 
    "systemuserroleid", 
    "roleid", 
    "systemuserid"})
@JsonInclude(Include.NON_NULL)
public class Systemuserroles extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.systemuserroles";
    }

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("systemuserroleid")
    protected String systemuserroleid;

    @JsonProperty("roleid")
    protected String roleid;

    @JsonProperty("systemuserid")
    protected String systemuserid;

    protected Systemuserroles() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSystemuserroles() {
        return new Builder();
    }

    public static final class Builder {
        private Long versionnumber;
        private String systemuserroleid;
        private String roleid;
        private String systemuserid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder systemuserroleid(String systemuserroleid) {
            this.systemuserroleid = systemuserroleid;
            this.changedFields = changedFields.add("systemuserroleid");
            return this;
        }

        public Builder roleid(String roleid) {
            this.roleid = roleid;
            this.changedFields = changedFields.add("roleid");
            return this;
        }

        public Builder systemuserid(String systemuserid) {
            this.systemuserid = systemuserid;
            this.changedFields = changedFields.add("systemuserid");
            return this;
        }

        public Systemuserroles build() {
            Systemuserroles _x = new Systemuserroles();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.systemuserroles";
            _x.versionnumber = versionnumber;
            _x.systemuserroleid = systemuserroleid;
            _x.roleid = roleid;
            _x.systemuserid = systemuserid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && systemuserroleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(systemuserroleid.toString()));
        }
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Systemuserroles withVersionnumber(Long versionnumber) {
        Systemuserroles _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemuserroles");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="systemuserroleid")
    @JsonIgnore
    public Optional<String> getSystemuserroleid() {
        return Optional.ofNullable(systemuserroleid);
    }

    public Systemuserroles withSystemuserroleid(String systemuserroleid) {
        Systemuserroles _x = _copy();
        _x.changedFields = changedFields.add("systemuserroleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemuserroles");
        _x.systemuserroleid = systemuserroleid;
        return _x;
    }

    @Property(name="roleid")
    @JsonIgnore
    public Optional<String> getRoleid() {
        return Optional.ofNullable(roleid);
    }

    public Systemuserroles withRoleid(String roleid) {
        Systemuserroles _x = _copy();
        _x.changedFields = changedFields.add("roleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemuserroles");
        _x.roleid = roleid;
        return _x;
    }

    @Property(name="systemuserid")
    @JsonIgnore
    public Optional<String> getSystemuserid() {
        return Optional.ofNullable(systemuserid);
    }

    public Systemuserroles withSystemuserid(String systemuserid) {
        Systemuserroles _x = _copy();
        _x.changedFields = changedFields.add("systemuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemuserroles");
        _x.systemuserid = systemuserid;
        return _x;
    }

    public Systemuserroles withUnmappedField(String name, String value) {
        Systemuserroles _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Systemuserroles patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Systemuserroles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Systemuserroles put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Systemuserroles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Systemuserroles _copy() {
        Systemuserroles _x = new Systemuserroles();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.versionnumber = versionnumber;
        _x.systemuserroleid = systemuserroleid;
        _x.roleid = roleid;
        _x.systemuserid = systemuserid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Systemuserroles[");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("systemuserroleid=");
        b.append(this.systemuserroleid);
        b.append(", ");
        b.append("roleid=");
        b.append(this.roleid);
        b.append(", ");
        b.append("systemuserid=");
        b.append(this.systemuserid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
