package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "similarityruleid", 
    "similarityruleidunique", 
    "ngramsize", 
    "baseentitytypecode", 
    "statecode", 
    "_modifiedonbehalfby_value", 
    "solutionid", 
    "_transactioncurrencyid_value", 
    "excludeinactiverecords", 
    "ruleconditionxml", 
    "maxkeywords", 
    "utcconversiontimezonecode", 
    "overwritetime", 
    "name", 
    "modifiedon", 
    "componentstate", 
    "baseentityname", 
    "exchangerate", 
    "introducedversion", 
    "importsequencenumber", 
    "fetchxmllist", 
    "statuscode", 
    "createdon", 
    "description", 
    "versionnumber", 
    "_organizationid_value", 
    "_createdonbehalfby_value", 
    "ismanaged", 
    "activerulefetchxml", 
    "timezoneruleversionnumber", 
    "overriddencreatedon", 
    "matchingentityname", 
    "matchingentitytypecode"})
@JsonInclude(Include.NON_NULL)
public class Similarityrule extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.similarityrule";
    }

    @JsonProperty("similarityruleid")
    protected String similarityruleid;

    @JsonProperty("similarityruleidunique")
    protected String similarityruleidunique;

    @JsonProperty("ngramsize")
    protected Integer ngramsize;

    @JsonProperty("baseentitytypecode")
    protected Integer baseentitytypecode;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("excludeinactiverecords")
    protected Boolean excludeinactiverecords;

    @JsonProperty("ruleconditionxml")
    protected String ruleconditionxml;

    @JsonProperty("maxkeywords")
    protected Integer maxkeywords;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("baseentityname")
    protected String baseentityname;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("fetchxmllist")
    protected String fetchxmllist;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("activerulefetchxml")
    protected String activerulefetchxml;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("matchingentityname")
    protected String matchingentityname;

    @JsonProperty("matchingentitytypecode")
    protected Integer matchingentitytypecode;

    protected Similarityrule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSimilarityrule() {
        return new Builder();
    }

    public static final class Builder {
        private String similarityruleid;
        private String similarityruleidunique;
        private Integer ngramsize;
        private Integer baseentitytypecode;
        private Integer statecode;
        private String _modifiedonbehalfby_value;
        private String solutionid;
        private String _transactioncurrencyid_value;
        private Boolean excludeinactiverecords;
        private String ruleconditionxml;
        private Integer maxkeywords;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime overwritetime;
        private String name;
        private OffsetDateTime modifiedon;
        private Integer componentstate;
        private String baseentityname;
        private BigDecimal exchangerate;
        private String introducedversion;
        private Integer importsequencenumber;
        private String fetchxmllist;
        private Integer statuscode;
        private OffsetDateTime createdon;
        private String description;
        private Long versionnumber;
        private String _organizationid_value;
        private String _createdonbehalfby_value;
        private Boolean ismanaged;
        private String activerulefetchxml;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime overriddencreatedon;
        private String matchingentityname;
        private Integer matchingentitytypecode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder similarityruleid(String similarityruleid) {
            this.similarityruleid = similarityruleid;
            this.changedFields = changedFields.add("similarityruleid");
            return this;
        }

        public Builder similarityruleidunique(String similarityruleidunique) {
            this.similarityruleidunique = similarityruleidunique;
            this.changedFields = changedFields.add("similarityruleidunique");
            return this;
        }

        public Builder ngramsize(Integer ngramsize) {
            this.ngramsize = ngramsize;
            this.changedFields = changedFields.add("ngramsize");
            return this;
        }

        public Builder baseentitytypecode(Integer baseentitytypecode) {
            this.baseentitytypecode = baseentitytypecode;
            this.changedFields = changedFields.add("baseentitytypecode");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder excludeinactiverecords(Boolean excludeinactiverecords) {
            this.excludeinactiverecords = excludeinactiverecords;
            this.changedFields = changedFields.add("excludeinactiverecords");
            return this;
        }

        public Builder ruleconditionxml(String ruleconditionxml) {
            this.ruleconditionxml = ruleconditionxml;
            this.changedFields = changedFields.add("ruleconditionxml");
            return this;
        }

        public Builder maxkeywords(Integer maxkeywords) {
            this.maxkeywords = maxkeywords;
            this.changedFields = changedFields.add("maxkeywords");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder baseentityname(String baseentityname) {
            this.baseentityname = baseentityname;
            this.changedFields = changedFields.add("baseentityname");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder fetchxmllist(String fetchxmllist) {
            this.fetchxmllist = fetchxmllist;
            this.changedFields = changedFields.add("fetchxmllist");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder activerulefetchxml(String activerulefetchxml) {
            this.activerulefetchxml = activerulefetchxml;
            this.changedFields = changedFields.add("activerulefetchxml");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder matchingentityname(String matchingentityname) {
            this.matchingentityname = matchingentityname;
            this.changedFields = changedFields.add("matchingentityname");
            return this;
        }

        public Builder matchingentitytypecode(Integer matchingentitytypecode) {
            this.matchingentitytypecode = matchingentitytypecode;
            this.changedFields = changedFields.add("matchingentitytypecode");
            return this;
        }

        public Similarityrule build() {
            Similarityrule _x = new Similarityrule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.similarityrule";
            _x.similarityruleid = similarityruleid;
            _x.similarityruleidunique = similarityruleidunique;
            _x.ngramsize = ngramsize;
            _x.baseentitytypecode = baseentitytypecode;
            _x.statecode = statecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.solutionid = solutionid;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.excludeinactiverecords = excludeinactiverecords;
            _x.ruleconditionxml = ruleconditionxml;
            _x.maxkeywords = maxkeywords;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.overwritetime = overwritetime;
            _x.name = name;
            _x.modifiedon = modifiedon;
            _x.componentstate = componentstate;
            _x.baseentityname = baseentityname;
            _x.exchangerate = exchangerate;
            _x.introducedversion = introducedversion;
            _x.importsequencenumber = importsequencenumber;
            _x.fetchxmllist = fetchxmllist;
            _x.statuscode = statuscode;
            _x.createdon = createdon;
            _x.description = description;
            _x.versionnumber = versionnumber;
            _x._organizationid_value = _organizationid_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.ismanaged = ismanaged;
            _x.activerulefetchxml = activerulefetchxml;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.overriddencreatedon = overriddencreatedon;
            _x.matchingentityname = matchingentityname;
            _x.matchingentitytypecode = matchingentitytypecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && similarityruleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(similarityruleid.toString()));
        }
    }

    @Property(name="similarityruleid")
    @JsonIgnore
    public Optional<String> getSimilarityruleid() {
        return Optional.ofNullable(similarityruleid);
    }

    public Similarityrule withSimilarityruleid(String similarityruleid) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("similarityruleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.similarityruleid = similarityruleid;
        return _x;
    }

    @Property(name="similarityruleidunique")
    @JsonIgnore
    public Optional<String> getSimilarityruleidunique() {
        return Optional.ofNullable(similarityruleidunique);
    }

    public Similarityrule withSimilarityruleidunique(String similarityruleidunique) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("similarityruleidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.similarityruleidunique = similarityruleidunique;
        return _x;
    }

    @Property(name="ngramsize")
    @JsonIgnore
    public Optional<Integer> getNgramsize() {
        return Optional.ofNullable(ngramsize);
    }

    public Similarityrule withNgramsize(Integer ngramsize) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("ngramsize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.ngramsize = ngramsize;
        return _x;
    }

    @Property(name="baseentitytypecode")
    @JsonIgnore
    public Optional<Integer> getBaseentitytypecode() {
        return Optional.ofNullable(baseentitytypecode);
    }

    public Similarityrule withBaseentitytypecode(Integer baseentitytypecode) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("baseentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.baseentitytypecode = baseentitytypecode;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Similarityrule withStatecode(Integer statecode) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Similarityrule with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Similarityrule withSolutionid(String solutionid) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Similarityrule with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="excludeinactiverecords")
    @JsonIgnore
    public Optional<Boolean> getExcludeinactiverecords() {
        return Optional.ofNullable(excludeinactiverecords);
    }

    public Similarityrule withExcludeinactiverecords(Boolean excludeinactiverecords) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("excludeinactiverecords");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.excludeinactiverecords = excludeinactiverecords;
        return _x;
    }

    @Property(name="ruleconditionxml")
    @JsonIgnore
    public Optional<String> getRuleconditionxml() {
        return Optional.ofNullable(ruleconditionxml);
    }

    public Similarityrule withRuleconditionxml(String ruleconditionxml) {
        Checks.checkIsAscii(ruleconditionxml);
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("ruleconditionxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.ruleconditionxml = ruleconditionxml;
        return _x;
    }

    @Property(name="maxkeywords")
    @JsonIgnore
    public Optional<Integer> getMaxkeywords() {
        return Optional.ofNullable(maxkeywords);
    }

    public Similarityrule withMaxkeywords(Integer maxkeywords) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("maxkeywords");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.maxkeywords = maxkeywords;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Similarityrule withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Similarityrule withOverwritetime(OffsetDateTime overwritetime) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Similarityrule withName(String name) {
        Checks.checkIsAscii(name);
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.name = name;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Similarityrule withModifiedon(OffsetDateTime modifiedon) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Similarityrule withComponentstate(Integer componentstate) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="baseentityname")
    @JsonIgnore
    public Optional<String> getBaseentityname() {
        return Optional.ofNullable(baseentityname);
    }

    public Similarityrule withBaseentityname(String baseentityname) {
        Checks.checkIsAscii(baseentityname);
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("baseentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.baseentityname = baseentityname;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Similarityrule withExchangerate(BigDecimal exchangerate) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Similarityrule withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Similarityrule withImportsequencenumber(Integer importsequencenumber) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="fetchxmllist")
    @JsonIgnore
    public Optional<String> getFetchxmllist() {
        return Optional.ofNullable(fetchxmllist);
    }

    public Similarityrule withFetchxmllist(String fetchxmllist) {
        Checks.checkIsAscii(fetchxmllist);
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("fetchxmllist");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.fetchxmllist = fetchxmllist;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Similarityrule withStatuscode(Integer statuscode) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Similarityrule withCreatedon(OffsetDateTime createdon) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Similarityrule withDescription(String description) {
        Checks.checkIsAscii(description);
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.description = description;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Similarityrule withVersionnumber(Long versionnumber) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Similarityrule with_organizationid_value(String _organizationid_value) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Similarityrule with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Similarityrule withIsmanaged(Boolean ismanaged) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="activerulefetchxml")
    @JsonIgnore
    public Optional<String> getActiverulefetchxml() {
        return Optional.ofNullable(activerulefetchxml);
    }

    public Similarityrule withActiverulefetchxml(String activerulefetchxml) {
        Checks.checkIsAscii(activerulefetchxml);
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("activerulefetchxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.activerulefetchxml = activerulefetchxml;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Similarityrule withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Similarityrule withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="matchingentityname")
    @JsonIgnore
    public Optional<String> getMatchingentityname() {
        return Optional.ofNullable(matchingentityname);
    }

    public Similarityrule withMatchingentityname(String matchingentityname) {
        Checks.checkIsAscii(matchingentityname);
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("matchingentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.matchingentityname = matchingentityname;
        return _x;
    }

    @Property(name="matchingentitytypecode")
    @JsonIgnore
    public Optional<Integer> getMatchingentitytypecode() {
        return Optional.ofNullable(matchingentitytypecode);
    }

    public Similarityrule withMatchingentitytypecode(Integer matchingentitytypecode) {
        Similarityrule _x = _copy();
        _x.changedFields = changedFields.add("matchingentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.similarityrule");
        _x.matchingentitytypecode = matchingentitytypecode;
        return _x;
    }

    public Similarityrule withUnmappedField(String name, String value) {
        Similarityrule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="similarityrule_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSimilarityrule_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("similarityrule_AsyncOperations"), RequestHelper.getValue(unmappedFields, "similarityrule_AsyncOperations"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Similarityrule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Similarityrule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Similarityrule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Similarityrule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Similarityrule _copy() {
        Similarityrule _x = new Similarityrule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.similarityruleid = similarityruleid;
        _x.similarityruleidunique = similarityruleidunique;
        _x.ngramsize = ngramsize;
        _x.baseentitytypecode = baseentitytypecode;
        _x.statecode = statecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.solutionid = solutionid;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.excludeinactiverecords = excludeinactiverecords;
        _x.ruleconditionxml = ruleconditionxml;
        _x.maxkeywords = maxkeywords;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.overwritetime = overwritetime;
        _x.name = name;
        _x.modifiedon = modifiedon;
        _x.componentstate = componentstate;
        _x.baseentityname = baseentityname;
        _x.exchangerate = exchangerate;
        _x.introducedversion = introducedversion;
        _x.importsequencenumber = importsequencenumber;
        _x.fetchxmllist = fetchxmllist;
        _x.statuscode = statuscode;
        _x.createdon = createdon;
        _x.description = description;
        _x.versionnumber = versionnumber;
        _x._organizationid_value = _organizationid_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.ismanaged = ismanaged;
        _x.activerulefetchxml = activerulefetchxml;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.overriddencreatedon = overriddencreatedon;
        _x.matchingentityname = matchingentityname;
        _x.matchingentitytypecode = matchingentitytypecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Similarityrule[");
        b.append("similarityruleid=");
        b.append(this.similarityruleid);
        b.append(", ");
        b.append("similarityruleidunique=");
        b.append(this.similarityruleidunique);
        b.append(", ");
        b.append("ngramsize=");
        b.append(this.ngramsize);
        b.append(", ");
        b.append("baseentitytypecode=");
        b.append(this.baseentitytypecode);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("excludeinactiverecords=");
        b.append(this.excludeinactiverecords);
        b.append(", ");
        b.append("ruleconditionxml=");
        b.append(this.ruleconditionxml);
        b.append(", ");
        b.append("maxkeywords=");
        b.append(this.maxkeywords);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("baseentityname=");
        b.append(this.baseentityname);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("fetchxmllist=");
        b.append(this.fetchxmllist);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("activerulefetchxml=");
        b.append(this.activerulefetchxml);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("matchingentityname=");
        b.append(this.matchingentityname);
        b.append(", ");
        b.append("matchingentitytypecode=");
        b.append(this.matchingentitytypecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
