package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.enums.OptionSetType;

@JsonPropertyOrder({
    "@odata.type", 
    "Description", 
    "DisplayName", 
    "IsCustomOptionSet", 
    "IsGlobal", 
    "IsManaged", 
    "IsCustomizable", 
    "Name", 
    "ExternalTypeName", 
    "OptionSetType", 
    "IntroducedVersion"})
@JsonInclude(Include.NON_NULL)
public class OptionSetMetadataBase extends MetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OptionSetMetadataBase";
    }

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("IsCustomOptionSet")
    protected Boolean isCustomOptionSet;

    @JsonProperty("IsGlobal")
    protected Boolean isGlobal;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("ExternalTypeName")
    protected String externalTypeName;

    @JsonProperty("OptionSetType")
    protected OptionSetType optionSetType;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    protected OptionSetMetadataBase() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOptionSetMetadataBase() {
        return new Builder();
    }

    public static final class Builder {
        private String metadataId;
        private Boolean hasChanged;
        private Label description;
        private Label displayName;
        private Boolean isCustomOptionSet;
        private Boolean isGlobal;
        private Boolean isManaged;
        private BooleanManagedProperty isCustomizable;
        private String name;
        private String externalTypeName;
        private OptionSetType optionSetType;
        private String introducedVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder isCustomOptionSet(Boolean isCustomOptionSet) {
            this.isCustomOptionSet = isCustomOptionSet;
            this.changedFields = changedFields.add("IsCustomOptionSet");
            return this;
        }

        public Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.changedFields = changedFields.add("IsGlobal");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            this.changedFields = changedFields.add("ExternalTypeName");
            return this;
        }

        public Builder optionSetType(OptionSetType optionSetType) {
            this.optionSetType = optionSetType;
            this.changedFields = changedFields.add("OptionSetType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public OptionSetMetadataBase build() {
            OptionSetMetadataBase _x = new OptionSetMetadataBase();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OptionSetMetadataBase";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.description = description;
            _x.displayName = displayName;
            _x.isCustomOptionSet = isCustomOptionSet;
            _x.isGlobal = isGlobal;
            _x.isManaged = isManaged;
            _x.isCustomizable = isCustomizable;
            _x.name = name;
            _x.externalTypeName = externalTypeName;
            _x.optionSetType = optionSetType;
            _x.introducedVersion = introducedVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId.toString()));
        }
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public OptionSetMetadataBase withDescription(Label description) {
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("Description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.description = description;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public OptionSetMetadataBase withDisplayName(Label displayName) {
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("DisplayName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="IsCustomOptionSet")
    @JsonIgnore
    public Optional<Boolean> getIsCustomOptionSet() {
        return Optional.ofNullable(isCustomOptionSet);
    }

    public OptionSetMetadataBase withIsCustomOptionSet(Boolean isCustomOptionSet) {
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("IsCustomOptionSet");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.isCustomOptionSet = isCustomOptionSet;
        return _x;
    }

    @Property(name="IsGlobal")
    @JsonIgnore
    public Optional<Boolean> getIsGlobal() {
        return Optional.ofNullable(isGlobal);
    }

    public OptionSetMetadataBase withIsGlobal(Boolean isGlobal) {
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("IsGlobal");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.isGlobal = isGlobal;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public OptionSetMetadataBase withIsManaged(Boolean isManaged) {
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("IsManaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public OptionSetMetadataBase withIsCustomizable(BooleanManagedProperty isCustomizable) {
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("IsCustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public OptionSetMetadataBase withName(String name) {
        Checks.checkIsAscii(name);
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("Name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.name = name;
        return _x;
    }

    @Property(name="ExternalTypeName")
    @JsonIgnore
    public Optional<String> getExternalTypeName() {
        return Optional.ofNullable(externalTypeName);
    }

    public OptionSetMetadataBase withExternalTypeName(String externalTypeName) {
        Checks.checkIsAscii(externalTypeName);
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("ExternalTypeName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.externalTypeName = externalTypeName;
        return _x;
    }

    @Property(name="OptionSetType")
    @JsonIgnore
    public Optional<OptionSetType> getOptionSetType() {
        return Optional.ofNullable(optionSetType);
    }

    public OptionSetMetadataBase withOptionSetType(OptionSetType optionSetType) {
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("OptionSetType");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.optionSetType = optionSetType;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public OptionSetMetadataBase withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii(introducedVersion);
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = changedFields.add("IntroducedVersion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OptionSetMetadataBase");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    public OptionSetMetadataBase withUnmappedField(String name, String value) {
        OptionSetMetadataBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OptionSetMetadataBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OptionSetMetadataBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OptionSetMetadataBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OptionSetMetadataBase _copy() {
        OptionSetMetadataBase _x = new OptionSetMetadataBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.description = description;
        _x.displayName = displayName;
        _x.isCustomOptionSet = isCustomOptionSet;
        _x.isGlobal = isGlobal;
        _x.isManaged = isManaged;
        _x.isCustomizable = isCustomizable;
        _x.name = name;
        _x.externalTypeName = externalTypeName;
        _x.optionSetType = optionSetType;
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OptionSetMetadataBase[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("IsCustomOptionSet=");
        b.append(this.isCustomOptionSet);
        b.append(", ");
        b.append("IsGlobal=");
        b.append(this.isGlobal);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("ExternalTypeName=");
        b.append(this.externalTypeName);
        b.append(", ");
        b.append("OptionSetType=");
        b.append(this.optionSetType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
