package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statuscode", 
    "solutionid", 
    "msdyn_displayname", 
    "overriddencreatedon", 
    "componentidunique", 
    "msdyn_path", 
    "_modifiedonbehalfby_value", 
    "msdyn_helppageid", 
    "ismanaged", 
    "_createdonbehalfby_value", 
    "utcconversiontimezonecode", 
    "overwritetime", 
    "modifiedon", 
    "_modifiedby_value", 
    "_createdby_value", 
    "msdyn_locale", 
    "versionnumber", 
    "importsequencenumber", 
    "createdon", 
    "msdyn_content", 
    "statecode", 
    "timezoneruleversionnumber", 
    "componentstate", 
    "msdyn_contenttype", 
    "iscustomizable", 
    "_organizationid_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_helppage extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_helppage";
    }

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("msdyn_displayname")
    protected String msdyn_displayname;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("componentidunique")
    protected String componentidunique;

    @JsonProperty("msdyn_path")
    protected String msdyn_path;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("msdyn_helppageid")
    protected String msdyn_helppageid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("msdyn_locale")
    protected Integer msdyn_locale;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("msdyn_content")
    protected String msdyn_content;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("msdyn_contenttype")
    protected String msdyn_contenttype;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    protected Msdyn_helppage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_helppage() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statuscode;
        private String solutionid;
        private String msdyn_displayname;
        private OffsetDateTime overriddencreatedon;
        private String componentidunique;
        private String msdyn_path;
        private String _modifiedonbehalfby_value;
        private String msdyn_helppageid;
        private Boolean ismanaged;
        private String _createdonbehalfby_value;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime overwritetime;
        private OffsetDateTime modifiedon;
        private String _modifiedby_value;
        private String _createdby_value;
        private Integer msdyn_locale;
        private Long versionnumber;
        private Integer importsequencenumber;
        private OffsetDateTime createdon;
        private String msdyn_content;
        private Integer statecode;
        private Integer timezoneruleversionnumber;
        private Integer componentstate;
        private String msdyn_contenttype;
        private BooleanManagedProperty iscustomizable;
        private String _organizationid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder msdyn_displayname(String msdyn_displayname) {
            this.msdyn_displayname = msdyn_displayname;
            this.changedFields = changedFields.add("msdyn_displayname");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder componentidunique(String componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder msdyn_path(String msdyn_path) {
            this.msdyn_path = msdyn_path;
            this.changedFields = changedFields.add("msdyn_path");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder msdyn_helppageid(String msdyn_helppageid) {
            this.msdyn_helppageid = msdyn_helppageid;
            this.changedFields = changedFields.add("msdyn_helppageid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder msdyn_locale(Integer msdyn_locale) {
            this.msdyn_locale = msdyn_locale;
            this.changedFields = changedFields.add("msdyn_locale");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder msdyn_content(String msdyn_content) {
            this.msdyn_content = msdyn_content;
            this.changedFields = changedFields.add("msdyn_content");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder msdyn_contenttype(String msdyn_contenttype) {
            this.msdyn_contenttype = msdyn_contenttype;
            this.changedFields = changedFields.add("msdyn_contenttype");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Msdyn_helppage build() {
            Msdyn_helppage _x = new Msdyn_helppage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_helppage";
            _x.statuscode = statuscode;
            _x.solutionid = solutionid;
            _x.msdyn_displayname = msdyn_displayname;
            _x.overriddencreatedon = overriddencreatedon;
            _x.componentidunique = componentidunique;
            _x.msdyn_path = msdyn_path;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.msdyn_helppageid = msdyn_helppageid;
            _x.ismanaged = ismanaged;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.overwritetime = overwritetime;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdby_value = _createdby_value;
            _x.msdyn_locale = msdyn_locale;
            _x.versionnumber = versionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x.createdon = createdon;
            _x.msdyn_content = msdyn_content;
            _x.statecode = statecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.componentstate = componentstate;
            _x.msdyn_contenttype = msdyn_contenttype;
            _x.iscustomizable = iscustomizable;
            _x._organizationid_value = _organizationid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_helppageid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_helppageid.toString()));
        }
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_helppage withStatuscode(Integer statuscode) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Msdyn_helppage withSolutionid(String solutionid) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="msdyn_displayname")
    @JsonIgnore
    public Optional<String> getMsdyn_displayname() {
        return Optional.ofNullable(msdyn_displayname);
    }

    public Msdyn_helppage withMsdyn_displayname(String msdyn_displayname) {
        Checks.checkIsAscii(msdyn_displayname);
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_displayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.msdyn_displayname = msdyn_displayname;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_helppage withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<String> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Msdyn_helppage withComponentidunique(String componentidunique) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="msdyn_path")
    @JsonIgnore
    public Optional<String> getMsdyn_path() {
        return Optional.ofNullable(msdyn_path);
    }

    public Msdyn_helppage withMsdyn_path(String msdyn_path) {
        Checks.checkIsAscii(msdyn_path);
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_path");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.msdyn_path = msdyn_path;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_helppage with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_helppageid")
    @JsonIgnore
    public Optional<String> getMsdyn_helppageid() {
        return Optional.ofNullable(msdyn_helppageid);
    }

    public Msdyn_helppage withMsdyn_helppageid(String msdyn_helppageid) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_helppageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.msdyn_helppageid = msdyn_helppageid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Msdyn_helppage withIsmanaged(Boolean ismanaged) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_helppage with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_helppage withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Msdyn_helppage withOverwritetime(OffsetDateTime overwritetime) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_helppage withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_helppage with_modifiedby_value(String _modifiedby_value) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_helppage with_createdby_value(String _createdby_value) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="msdyn_locale")
    @JsonIgnore
    public Optional<Integer> getMsdyn_locale() {
        return Optional.ofNullable(msdyn_locale);
    }

    public Msdyn_helppage withMsdyn_locale(Integer msdyn_locale) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_locale");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.msdyn_locale = msdyn_locale;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_helppage withVersionnumber(Long versionnumber) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_helppage withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_helppage withCreatedon(OffsetDateTime createdon) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="msdyn_content")
    @JsonIgnore
    public Optional<String> getMsdyn_content() {
        return Optional.ofNullable(msdyn_content);
    }

    public Msdyn_helppage withMsdyn_content(String msdyn_content) {
        Checks.checkIsAscii(msdyn_content);
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_content");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.msdyn_content = msdyn_content;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_helppage withStatecode(Integer statecode) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_helppage withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Msdyn_helppage withComponentstate(Integer componentstate) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="msdyn_contenttype")
    @JsonIgnore
    public Optional<String> getMsdyn_contenttype() {
        return Optional.ofNullable(msdyn_contenttype);
    }

    public Msdyn_helppage withMsdyn_contenttype(String msdyn_contenttype) {
        Checks.checkIsAscii(msdyn_contenttype);
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_contenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.msdyn_contenttype = msdyn_contenttype;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Msdyn_helppage withIscustomizable(BooleanManagedProperty iscustomizable) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Msdyn_helppage with_organizationid_value(String _organizationid_value) {
        Msdyn_helppage _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_helppage");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    public Msdyn_helppage withUnmappedField(String name, String value) {
        Msdyn_helppage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="msdyn_helppage_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_helppage_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_helppage_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_helppage_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_helppage_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_helppage_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_helppage_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_helppage_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_helppage_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_helppage_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_helppage_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_helppage_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_helppage_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_helppage_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_helppage_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_helppage_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_helppage_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_helppage_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_helppage_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_helppage_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_helppage_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_helppage_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_helppage_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_helppage_PrincipalObjectAttributeAccesses"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_helppage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_helppage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_helppage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_helppage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_helppage _copy() {
        Msdyn_helppage _x = new Msdyn_helppage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statuscode = statuscode;
        _x.solutionid = solutionid;
        _x.msdyn_displayname = msdyn_displayname;
        _x.overriddencreatedon = overriddencreatedon;
        _x.componentidunique = componentidunique;
        _x.msdyn_path = msdyn_path;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.msdyn_helppageid = msdyn_helppageid;
        _x.ismanaged = ismanaged;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.overwritetime = overwritetime;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdby_value = _createdby_value;
        _x.msdyn_locale = msdyn_locale;
        _x.versionnumber = versionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x.createdon = createdon;
        _x.msdyn_content = msdyn_content;
        _x.statecode = statecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.componentstate = componentstate;
        _x.msdyn_contenttype = msdyn_contenttype;
        _x.iscustomizable = iscustomizable;
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_helppage[");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("msdyn_displayname=");
        b.append(this.msdyn_displayname);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("msdyn_path=");
        b.append(this.msdyn_path);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("msdyn_helppageid=");
        b.append(this.msdyn_helppageid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("msdyn_locale=");
        b.append(this.msdyn_locale);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("msdyn_content=");
        b.append(this.msdyn_content);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("msdyn_contenttype=");
        b.append(this.msdyn_contenttype);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
