package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ggw_crewid", 
    "versionnumber", 
    "ggw_ggw_crew_ggw_teamid", 
    "ggw_teamid"})
@JsonInclude(Include.NON_NULL)
public class Ggw_ggw_crew_ggw_team extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ggw_ggw_crew_ggw_team";
    }

    @JsonProperty("ggw_crewid")
    protected String ggw_crewid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("ggw_ggw_crew_ggw_teamid")
    protected String ggw_ggw_crew_ggw_teamid;

    @JsonProperty("ggw_teamid")
    protected String ggw_teamid;

    protected Ggw_ggw_crew_ggw_team() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGgw_ggw_crew_ggw_team() {
        return new Builder();
    }

    public static final class Builder {
        private String ggw_crewid;
        private Long versionnumber;
        private String ggw_ggw_crew_ggw_teamid;
        private String ggw_teamid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ggw_crewid(String ggw_crewid) {
            this.ggw_crewid = ggw_crewid;
            this.changedFields = changedFields.add("ggw_crewid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder ggw_ggw_crew_ggw_teamid(String ggw_ggw_crew_ggw_teamid) {
            this.ggw_ggw_crew_ggw_teamid = ggw_ggw_crew_ggw_teamid;
            this.changedFields = changedFields.add("ggw_ggw_crew_ggw_teamid");
            return this;
        }

        public Builder ggw_teamid(String ggw_teamid) {
            this.ggw_teamid = ggw_teamid;
            this.changedFields = changedFields.add("ggw_teamid");
            return this;
        }

        public Ggw_ggw_crew_ggw_team build() {
            Ggw_ggw_crew_ggw_team _x = new Ggw_ggw_crew_ggw_team();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ggw_ggw_crew_ggw_team";
            _x.ggw_crewid = ggw_crewid;
            _x.versionnumber = versionnumber;
            _x.ggw_ggw_crew_ggw_teamid = ggw_ggw_crew_ggw_teamid;
            _x.ggw_teamid = ggw_teamid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && ggw_ggw_crew_ggw_teamid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(ggw_ggw_crew_ggw_teamid.toString()));
        }
    }

    @Property(name="ggw_crewid")
    @JsonIgnore
    public Optional<String> getGgw_crewid() {
        return Optional.ofNullable(ggw_crewid);
    }

    public Ggw_ggw_crew_ggw_team withGgw_crewid(String ggw_crewid) {
        Ggw_ggw_crew_ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_crewid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_ggw_crew_ggw_team");
        _x.ggw_crewid = ggw_crewid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Ggw_ggw_crew_ggw_team withVersionnumber(Long versionnumber) {
        Ggw_ggw_crew_ggw_team _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_ggw_crew_ggw_team");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="ggw_ggw_crew_ggw_teamid")
    @JsonIgnore
    public Optional<String> getGgw_ggw_crew_ggw_teamid() {
        return Optional.ofNullable(ggw_ggw_crew_ggw_teamid);
    }

    public Ggw_ggw_crew_ggw_team withGgw_ggw_crew_ggw_teamid(String ggw_ggw_crew_ggw_teamid) {
        Ggw_ggw_crew_ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_ggw_crew_ggw_teamid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_ggw_crew_ggw_team");
        _x.ggw_ggw_crew_ggw_teamid = ggw_ggw_crew_ggw_teamid;
        return _x;
    }

    @Property(name="ggw_teamid")
    @JsonIgnore
    public Optional<String> getGgw_teamid() {
        return Optional.ofNullable(ggw_teamid);
    }

    public Ggw_ggw_crew_ggw_team withGgw_teamid(String ggw_teamid) {
        Ggw_ggw_crew_ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_teamid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_ggw_crew_ggw_team");
        _x.ggw_teamid = ggw_teamid;
        return _x;
    }

    public Ggw_ggw_crew_ggw_team withUnmappedField(String name, String value) {
        Ggw_ggw_crew_ggw_team _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ggw_ggw_crew_ggw_team patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Ggw_ggw_crew_ggw_team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ggw_ggw_crew_ggw_team put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Ggw_ggw_crew_ggw_team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Ggw_ggw_crew_ggw_team _copy() {
        Ggw_ggw_crew_ggw_team _x = new Ggw_ggw_crew_ggw_team();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ggw_crewid = ggw_crewid;
        _x.versionnumber = versionnumber;
        _x.ggw_ggw_crew_ggw_teamid = ggw_ggw_crew_ggw_teamid;
        _x.ggw_teamid = ggw_teamid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Ggw_ggw_crew_ggw_team[");
        b.append("ggw_crewid=");
        b.append(this.ggw_crewid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("ggw_ggw_crew_ggw_teamid=");
        b.append(this.ggw_ggw_crew_ggw_teamid);
        b.append(", ");
        b.append("ggw_teamid=");
        b.append(this.ggw_teamid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
