package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedonbehalfby_value", 
    "_ownerid_value", 
    "utcconversiontimezonecode", 
    "ismanaged", 
    "value", 
    "schemaname", 
    "environmentvariablevalueid", 
    "_modifiedby_value", 
    "iscustomizable", 
    "timezoneruleversionnumber", 
    "_environmentvariabledefinitionid_value", 
    "modifiedon", 
    "environmentvariablevalueidunique", 
    "statecode", 
    "_owninguser_value", 
    "overriddencreatedon", 
    "_owningteam_value", 
    "introducedversion", 
    "statuscode", 
    "_owningbusinessunit_value", 
    "_createdonbehalfby_value", 
    "versionnumber", 
    "createdon", 
    "importsequencenumber", 
    "componentstate", 
    "_createdby_value", 
    "solutionid", 
    "overwritetime"})
@JsonInclude(Include.NON_NULL)
public class Environmentvariablevalue extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.environmentvariablevalue";
    }

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("value")
    protected String value;

    @JsonProperty("schemaname")
    protected String schemaname;

    @JsonProperty("environmentvariablevalueid")
    protected String environmentvariablevalueid;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_environmentvariabledefinitionid_value")
    protected String _environmentvariabledefinitionid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("environmentvariablevalueidunique")
    protected String environmentvariablevalueidunique;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    protected Environmentvariablevalue() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEnvironmentvariablevalue() {
        return new Builder();
    }

    public static final class Builder {
        private String _modifiedonbehalfby_value;
        private String _ownerid_value;
        private Integer utcconversiontimezonecode;
        private Boolean ismanaged;
        private String value;
        private String schemaname;
        private String environmentvariablevalueid;
        private String _modifiedby_value;
        private BooleanManagedProperty iscustomizable;
        private Integer timezoneruleversionnumber;
        private String _environmentvariabledefinitionid_value;
        private OffsetDateTime modifiedon;
        private String environmentvariablevalueidunique;
        private Integer statecode;
        private String _owninguser_value;
        private OffsetDateTime overriddencreatedon;
        private String _owningteam_value;
        private String introducedversion;
        private Integer statuscode;
        private String _owningbusinessunit_value;
        private String _createdonbehalfby_value;
        private Long versionnumber;
        private OffsetDateTime createdon;
        private Integer importsequencenumber;
        private Integer componentstate;
        private String _createdby_value;
        private String solutionid;
        private OffsetDateTime overwritetime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Builder schemaname(String schemaname) {
            this.schemaname = schemaname;
            this.changedFields = changedFields.add("schemaname");
            return this;
        }

        public Builder environmentvariablevalueid(String environmentvariablevalueid) {
            this.environmentvariablevalueid = environmentvariablevalueid;
            this.changedFields = changedFields.add("environmentvariablevalueid");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _environmentvariabledefinitionid_value(String _environmentvariabledefinitionid_value) {
            this._environmentvariabledefinitionid_value = _environmentvariabledefinitionid_value;
            this.changedFields = changedFields.add("_environmentvariabledefinitionid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder environmentvariablevalueidunique(String environmentvariablevalueidunique) {
            this.environmentvariablevalueidunique = environmentvariablevalueidunique;
            this.changedFields = changedFields.add("environmentvariablevalueidunique");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Environmentvariablevalue build() {
            Environmentvariablevalue _x = new Environmentvariablevalue();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.environmentvariablevalue";
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._ownerid_value = _ownerid_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.ismanaged = ismanaged;
            _x.value = value;
            _x.schemaname = schemaname;
            _x.environmentvariablevalueid = environmentvariablevalueid;
            _x._modifiedby_value = _modifiedby_value;
            _x.iscustomizable = iscustomizable;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._environmentvariabledefinitionid_value = _environmentvariabledefinitionid_value;
            _x.modifiedon = modifiedon;
            _x.environmentvariablevalueidunique = environmentvariablevalueidunique;
            _x.statecode = statecode;
            _x._owninguser_value = _owninguser_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._owningteam_value = _owningteam_value;
            _x.introducedversion = introducedversion;
            _x.statuscode = statuscode;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x.createdon = createdon;
            _x.importsequencenumber = importsequencenumber;
            _x.componentstate = componentstate;
            _x._createdby_value = _createdby_value;
            _x.solutionid = solutionid;
            _x.overwritetime = overwritetime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && environmentvariablevalueid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(environmentvariablevalueid.toString()));
        }
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Environmentvariablevalue with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Environmentvariablevalue with_ownerid_value(String _ownerid_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Environmentvariablevalue withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Environmentvariablevalue withIsmanaged(Boolean ismanaged) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public Environmentvariablevalue withValue(String value) {
        Checks.checkIsAscii(value);
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.value = value;
        return _x;
    }

    @Property(name="schemaname")
    @JsonIgnore
    public Optional<String> getSchemaname() {
        return Optional.ofNullable(schemaname);
    }

    public Environmentvariablevalue withSchemaname(String schemaname) {
        Checks.checkIsAscii(schemaname);
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("schemaname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.schemaname = schemaname;
        return _x;
    }

    @Property(name="environmentvariablevalueid")
    @JsonIgnore
    public Optional<String> getEnvironmentvariablevalueid() {
        return Optional.ofNullable(environmentvariablevalueid);
    }

    public Environmentvariablevalue withEnvironmentvariablevalueid(String environmentvariablevalueid) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("environmentvariablevalueid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.environmentvariablevalueid = environmentvariablevalueid;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Environmentvariablevalue with_modifiedby_value(String _modifiedby_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Environmentvariablevalue withIscustomizable(BooleanManagedProperty iscustomizable) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Environmentvariablevalue withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_environmentvariabledefinitionid_value")
    @JsonIgnore
    public Optional<String> get_environmentvariabledefinitionid_value() {
        return Optional.ofNullable(_environmentvariabledefinitionid_value);
    }

    public Environmentvariablevalue with_environmentvariabledefinitionid_value(String _environmentvariabledefinitionid_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_environmentvariabledefinitionid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._environmentvariabledefinitionid_value = _environmentvariabledefinitionid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Environmentvariablevalue withModifiedon(OffsetDateTime modifiedon) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="environmentvariablevalueidunique")
    @JsonIgnore
    public Optional<String> getEnvironmentvariablevalueidunique() {
        return Optional.ofNullable(environmentvariablevalueidunique);
    }

    public Environmentvariablevalue withEnvironmentvariablevalueidunique(String environmentvariablevalueidunique) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("environmentvariablevalueidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.environmentvariablevalueidunique = environmentvariablevalueidunique;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Environmentvariablevalue withStatecode(Integer statecode) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Environmentvariablevalue with_owninguser_value(String _owninguser_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Environmentvariablevalue withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Environmentvariablevalue with_owningteam_value(String _owningteam_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Environmentvariablevalue withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Environmentvariablevalue withStatuscode(Integer statuscode) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Environmentvariablevalue with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Environmentvariablevalue with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Environmentvariablevalue withVersionnumber(Long versionnumber) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Environmentvariablevalue withCreatedon(OffsetDateTime createdon) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Environmentvariablevalue withImportsequencenumber(Integer importsequencenumber) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Environmentvariablevalue withComponentstate(Integer componentstate) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Environmentvariablevalue with_createdby_value(String _createdby_value) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Environmentvariablevalue withSolutionid(String solutionid) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Environmentvariablevalue withOverwritetime(OffsetDateTime overwritetime) {
        Environmentvariablevalue _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.environmentvariablevalue");
        _x.overwritetime = overwritetime;
        return _x;
    }

    public Environmentvariablevalue withUnmappedField(String name, String value) {
        Environmentvariablevalue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="environmentvariablevalue_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getEnvironmentvariablevalue_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("environmentvariablevalue_SyncErrors"), RequestHelper.getValue(unmappedFields, "environmentvariablevalue_SyncErrors"));
    }

    @NavigationProperty(name="environmentvariablevalue_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getEnvironmentvariablevalue_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("environmentvariablevalue_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "environmentvariablevalue_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="environmentvariablevalue_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getEnvironmentvariablevalue_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("environmentvariablevalue_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "environmentvariablevalue_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="environmentvariablevalue_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getEnvironmentvariablevalue_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("environmentvariablevalue_AsyncOperations"), RequestHelper.getValue(unmappedFields, "environmentvariablevalue_AsyncOperations"));
    }

    @NavigationProperty(name="environmentvariablevalue_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getEnvironmentvariablevalue_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("environmentvariablevalue_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "environmentvariablevalue_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="environmentvariablevalue_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getEnvironmentvariablevalue_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("environmentvariablevalue_ProcessSession"), RequestHelper.getValue(unmappedFields, "environmentvariablevalue_ProcessSession"));
    }

    @NavigationProperty(name="environmentvariablevalue_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getEnvironmentvariablevalue_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("environmentvariablevalue_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "environmentvariablevalue_BulkDeleteFailures"));
    }

    @NavigationProperty(name="environmentvariablevalue_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getEnvironmentvariablevalue_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("environmentvariablevalue_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "environmentvariablevalue_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="EnvironmentVariableDefinitionId")
    @JsonIgnore
    public EnvironmentvariabledefinitionRequest getEnvironmentVariableDefinitionId() {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("EnvironmentVariableDefinitionId"), RequestHelper.getValue(unmappedFields, "EnvironmentVariableDefinitionId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Environmentvariablevalue patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Environmentvariablevalue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Environmentvariablevalue put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Environmentvariablevalue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Environmentvariablevalue _copy() {
        Environmentvariablevalue _x = new Environmentvariablevalue();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._ownerid_value = _ownerid_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.ismanaged = ismanaged;
        _x.value = value;
        _x.schemaname = schemaname;
        _x.environmentvariablevalueid = environmentvariablevalueid;
        _x._modifiedby_value = _modifiedby_value;
        _x.iscustomizable = iscustomizable;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._environmentvariabledefinitionid_value = _environmentvariabledefinitionid_value;
        _x.modifiedon = modifiedon;
        _x.environmentvariablevalueidunique = environmentvariablevalueidunique;
        _x.statecode = statecode;
        _x._owninguser_value = _owninguser_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._owningteam_value = _owningteam_value;
        _x.introducedversion = introducedversion;
        _x.statuscode = statuscode;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x.createdon = createdon;
        _x.importsequencenumber = importsequencenumber;
        _x.componentstate = componentstate;
        _x._createdby_value = _createdby_value;
        _x.solutionid = solutionid;
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Environmentvariablevalue[");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append(", ");
        b.append("schemaname=");
        b.append(this.schemaname);
        b.append(", ");
        b.append("environmentvariablevalueid=");
        b.append(this.environmentvariablevalueid);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_environmentvariabledefinitionid_value=");
        b.append(this._environmentvariabledefinitionid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("environmentvariablevalueidunique=");
        b.append(this.environmentvariablevalueidunique);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
